package clinical.web.services;

import java.math.BigDecimal;
import java.sql.Connection;
import java.util.Date;

import org.apache.commons.logging.LogFactory;

import clinical.server.dao.BugReportDAO;
import clinical.server.vo.BugReport;
import clinical.utils.GenUtils;
import clinical.web.DAOFactory;
import clinical.web.ISequenceHelper;
import clinical.web.ServiceFactory;
import clinical.web.common.IDBPoolService;
import clinical.web.common.UserInfo;
import clinical.web.exception.BaseException;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: BugReportServiceImpl.java 492 2011-12-06 21:50:33Z bozyurt $
 */
public class BugReportServiceImpl extends AbstractServiceImpl implements
		IBugReportService {
	public BugReportServiceImpl(String dbID) throws BaseException {
		super(dbID);
		log = LogFactory.getLog(BugReportServiceImpl.class);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * clinical.web.services.IBugReportService#addBugReport(clinical.web.common
	 * .UserInfo, java.lang.String, int, int, java.lang.String,
	 * java.lang.String)
	 */
	public void addBugReport(UserInfo ui, String subjectID, int expID,
			int visitID, String reportingUser, String comments)
			throws Exception {
		Connection con = null;
		IDBPoolService dbPoolService = null;

		try {
			dbPoolService = ServiceFactory.getPoolService(this.theDBID);
			con = dbPoolService.getConnection(ui.getName());
			con.setAutoCommit(false);
			ISequenceHelper sequenceHelper = ServiceFactory
					.getSequenceHelper(this.theDBID);
			BugReportDAO dao = DAOFactory.createBugReportDAO(this.theDBID);
			BugReport br = new BugReport();
			br.setSubjectid(subjectID);
			br.setExpId(GenUtils.toBigDecimal(expID));
			br.setWebuser(reportingUser);
			br.setComments(comments);
			if (visitID > 0) {
				br.setComponentId(GenUtils.toBigDecimal(visitID));
			}
			BigDecimal uniqueId = sequenceHelper.getNextUID(con,
					"nc_bug_report", "uniqueId");
			br.setUniqueid(uniqueId);
			br.setModtime(new Date());

			dao.insert(con, br);
			con.commit();
		} catch (Throwable t) {
			if (con != null) {
				con.rollback();
			}
			if (t instanceof Exception) {
				throw (Exception) t;
			} else {
				throw new Exception(t);
			}
		} finally {
			if (dbPoolService != null) {
				dbPoolService.releaseConnection(ui.getName(), con);
			}
		}

	}

}
