package clinical.web.services;

import java.math.BigDecimal;
import java.sql.Connection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import clinical.server.dao.ConfWebuserDAO;
import clinical.server.dao.ContactInfoDAO;
import clinical.server.vo.ConfWebuser;
import clinical.server.vo.ContactInfo;
import clinical.utils.Assertion;
import clinical.web.DAOFactory;
import clinical.web.ISequenceHelper;
import clinical.web.ServiceFactory;
import clinical.web.common.UserInfo;
import clinical.web.exception.BaseException;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: ContactInfoService.java 366 2011-05-05 20:06:27Z bozyurt $
 */
public class ContactInfoService extends AbstractServiceImpl implements
		IContactInfoService {
	protected ISequenceHelper seqHelper;

	public ContactInfoService(String dbID) throws BaseException {
		super(dbID);
		seqHelper = ServiceFactory.getSequenceHelper(dbID);
	}

	public ConfWebuser getWebUser(UserInfo ui) throws Exception {
		Connection con = null;
		try {
			con = pool.getConnection(ui.getName());
			ConfWebuser webUser = getWebUser(ui, con);
			return webUser;
		} finally {
			releaseConnection(con, ui);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * clinical.web.services.IContactInfoService#getContactInfo(clinical.web
	 * .common.UserInfo)
	 */
	public ContactInfo getContactInfo(UserInfo ui) throws Exception {
		Connection con = null;
		try {
			con = pool.getConnection(ui.getName());
			ConfWebuser webUser = getWebUser(ui, con);
			ContactInfoDAO ciDAO = DAOFactory.createContactInfoDAO(theDBID);
			ContactInfo ciCR = new ContactInfo();
			ciCR.setWebuserId(webUser.getUniqueId());
			List<ContactInfo> ciList = ciDAO.find(con, ciCR);
			if (ciList.isEmpty()) {
				return null;
			} else {
				return ciList.get(0);
			}
		} finally {
			releaseConnection(con, ui);
		}
	}

	public Map<ConfWebuser, ContactInfo> getAllContactInfos(UserInfo ui)
			throws Exception {
		Connection con = null;
		try {
			con = pool.getConnection(ui.getName());
			con.setAutoCommit(false);
			ConfWebuserDAO wuDAO = DAOFactory.createConfWebuserDAO(theDBID);
			List<ConfWebuser> allWebUsers = wuDAO.find(con, new ConfWebuser());
			Map<BigDecimal, ConfWebuser> webUserMap = new HashMap<BigDecimal, ConfWebuser>();
			for (ConfWebuser webUser : allWebUsers) {
				webUserMap.put(webUser.getUniqueId(), webUser);
			}

			Map<ConfWebuser, ContactInfo> map = new HashMap<ConfWebuser, ContactInfo>();

			ContactInfoDAO ciDAO = DAOFactory.createContactInfoDAO(theDBID);
			List<ContactInfo> ciList = ciDAO.find(con, new ContactInfo());
			for (ContactInfo ci : ciList) {
				ConfWebuser webuser = webUserMap.get(ci.getWebuserId());
				map.put(webuser,ci);
			}
			con.commit();
			return map;
		} catch (Exception x) {
			handleErrorAndRollBack(con, "getAllContactInfos", x, true);
		} finally {
			releaseConnection(con, ui);
		}
		return null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * clinical.web.services.IContactInfoService#saveContactInfo(clinical.web
	 * .common.UserInfo, clinical.server.vo.ContactInfo)
	 */
	public void saveContactInfo(UserInfo ui, ContactInfo contactInfo)
			throws Exception {
		Connection con = null;
		try {
			con = pool.getConnection(ui.getName());
			con.setAutoCommit(false);
			ConfWebuser webUser = getWebUser(ui, con);
			if (contactInfo.getWebuserId() == null) {
				contactInfo.setWebuserId(webUser.getUniqueId());
			}

			ContactInfoDAO ciDAO = DAOFactory.createContactInfoDAO(theDBID);
			ContactInfo ciCR = new ContactInfo();
			ciCR.setWebuserId(webUser.getUniqueId());

			List<ContactInfo> ciList = ciDAO.find(con, ciCR);

			contactInfo.setModTime(new Date());

			if (ciList.isEmpty()) {
				BigDecimal nextUID = seqHelper.getNextUID(ui,
						"nc_contact_info", "uniqueid");
				contactInfo.setUniqueid(nextUID);
				ciDAO.insert(con, contactInfo);
			} else {
				ciDAO.update(con, contactInfo, ciCR);
			}

			con.commit();
		} catch (Exception x) {
			handleErrorAndRollBack(con, "saveContactInfo", x, true);
		} finally {
			releaseConnection(con, ui);
		}
	}

	protected ConfWebuser getWebUser(UserInfo ui, Connection con)
			throws Exception {
		ConfWebuserDAO wuDAO = DAOFactory.createConfWebuserDAO(theDBID);
		ConfWebuser wuCR = new ConfWebuser();
		wuCR.setName(ui.getPerceivedName());
		List<ConfWebuser> wuList = wuDAO.find(con, wuCR);
		Assertion.assertTrue(wuList.size() == 1);
		ConfWebuser webUser = wuList.get(0);
		return webUser;
	}
}
