package clinical.web.services;

import java.math.BigDecimal;
import java.sql.Connection;
import java.util.List;

import clinical.server.vo.JobProvenance;
import clinical.server.vo.Jobs;
import clinical.web.common.UserInfo;
import clinical.web.common.query.Operator;
import clinical.web.vo.JobProvenanceInfo;
import clinical.web.vo.JobProvenanceValueSummary;
import clinical.web.vo.JobProvenanceInfo.JobProvenanceParamInfo;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id$
 */
public interface IJobProvenanceService {

	/**
	 * 
	 * @param ui
	 * @param expId
	 * @param subjectID
	 * @param visitId
	 * @return
	 * @throws Exception
	 */
	public List<JobProvenanceInfo> findJobProvenances(UserInfo ui, int expId,
			String subjectID, int visitId) throws Exception;

	/**
	 * 
	 * @param ui
	 * @param jpiList
	 * @throws Exception
	 */
	public abstract void deleteJobProvenance(UserInfo ui,
			List<JobProvenanceInfo> jpiList) throws Exception;

	/**
	 * 
	 * @param ui
	 * @param jpi
	 * @throws Exception
	 */
	public abstract void saveJobProvenance(UserInfo ui, JobProvenanceInfo jpi)
			throws Exception;

	/**
	 * returns null if not match have been found.
	 * 
	 * @param ui
	 * @param jobUniqueID
	 * @return
	 * @throws Exception
	 */
	public abstract List<JobProvenanceInfo> findJobProvenancesByJobUniqueID(
			UserInfo ui, BigDecimal jobUniqueID) throws Exception;

	public void saveJobProvenance(Connection con, JobProvenanceInfo jpi)
			throws Exception;

	public Jobs getTheJob(UserInfo ui, String jobID, String jobUser)
			throws Exception;

	public List<JobProvenanceInfo> findJobProvenances(Connection con,
			List<Jobs> jobsList) throws Exception;

	public List<JobProvenanceValueSummary> queryForJobProvenance(UserInfo ui,
			Operator rootOp, List<Integer> experimentIds) throws Exception;

	/**
	 * add new provenance parameters to an existing provenance record or update
	 * the values of existing provenance parameters.
	 * 
	 * @param ui
	 * @param jobUniqueID
	 * @param jpiList
	 * @throws Exception
	 */
	public void addUpdateProvenanceParams(UserInfo ui, Integer jobUniqueID,
			List<JobProvenanceParamInfo> jpiList) throws Exception;

	public void addUpdateProvenanceParams(Connection con, Integer jobUniqueID,
			List<JobProvenanceParamInfo> jpiList) throws Exception;
	
	public JobProvenance findJobProvenanceByJobID(UserInfo ui, String jobID)
			throws Exception;
}