package clinical.web.services;

import java.sql.Connection;
import java.util.List;

import clinical.web.common.UserInfo;
import clinical.web.common.query.Operator;
import clinical.web.vo.JobResultGroupInfo;
import clinical.web.vo.JobResultValueSummary;
import clinical.web.vo.StoredJobResultGroupInfo;

public interface IJobResultService {

	public abstract void saveJobResultGroup(UserInfo ui, JobResultGroupInfo jrgi)
			throws Exception;

	public abstract void deleteJobResultGroup(UserInfo ui,
			String jobResultGroupName, boolean deleteJobResultTypes)
			throws Exception;

	public abstract void deleteStoredJobResultGroup(UserInfo ui,
			Integer storedJobResultGroupId) throws Exception;

	public abstract void saveStoredJobResultGroup(UserInfo ui,
			StoredJobResultGroupInfo sjrgi, Integer jobProvenanceId)
			throws Exception;

	public abstract List<JobResultValueSummary> queryForJobResults(UserInfo ui,
			Operator rootOp, List<JobResultGroupInfo> jrgiList,
			List<Integer> experimentIds) throws Exception;
	
	public List<JobResultGroupInfo> getJobResultGroups(Connection con)
			throws Exception;
}