package clinical.web.services;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: JobManagementHelper.java 366 2011-05-05 20:06:27Z bozyurt $
 */
public class JobManagementHelper {

	public static String buildSavedResultStringForDB(String[] savedResultFiles) {
		StringBuilder sb = new StringBuilder();
		for (int i = 0; i < savedResultFiles.length; i++) {
			String s = savedResultFiles[i];
			if (i == 0) {
				sb.append(s);
			} else {
				sb.append(';');
				if (s.indexOf('/') != -1) {
					int idx = s.lastIndexOf('/');
					sb.append(s.substring(idx + 1));
				} else {
					sb.append(s);
				}
			}
		}
		return sb.toString();
	}

	public static String[] fromDBSavedResultsFileString(
			String savedResultFileStr) {
		if (savedResultFileStr == null)
			return null;
		String[] paths = savedResultFileStr.split(";");
		if (paths.length == 1) {
			return paths;
		} else {
			int idx = paths[0].lastIndexOf('/');
			if (idx == -1) {
				return paths;
			} else {
				String[] srfArr = new String[paths.length];
				srfArr[0] = paths[0];
				String cp = paths[0].substring(0, idx);
				for (int i = 1; i < paths.length; i++) {
					srfArr[i] = cp + "/" + paths[i];
				}
				return srfArr;
			}
		}
	}

}
