package clinical.web.services;

import java.math.*;
import java.sql.*;

import clinical.web.*;
import clinical.web.common.UserInfo;
import clinical.web.exception.*;

/**
 * Encapsulates Oracle database sequence retrieval.
 * 
 * @author I. Burak Ozyurt
 * @version $Id: OracleSequenceHelper.java 366 2011-05-05 20:06:27Z bozyurt $
 */

public class OracleSequenceHelper extends AbstractSequenceHelper {

	protected OracleSequenceHelper(String dbID) throws BaseException {
		super(dbID);
	}

	public synchronized static OracleSequenceHelper getInstance(String dbID,
			String dbType) throws BaseException {
		OracleSequenceHelper seqHelper = (OracleSequenceHelper) instanceMap
				.get(dbID + "_" + dbType);
		if (seqHelper == null) {
			seqHelper = new OracleSequenceHelper(dbID);
			instanceMap.put(dbID, seqHelper);
		}
		return seqHelper;
	}

	public synchronized BigDecimal getNextUID(Connection con, String tableName,
			String columnName) throws BaseException {
		Statement st = null;
		ResultSet rs = null;
		try {
			st = con.createStatement();
			rs = st.executeQuery("select uid_seq.nextval from dual");
			if (rs.next()) {
				BigDecimal uid = rs.getBigDecimal(1);
				fireSequenceNumCreateEvent(tableName, columnName, uid.toString());
				return uid;
			}
		} catch (SQLException x) {
			throw new BaseException(x);
		} finally {
			DBUtils.close(st, rs);
		}
		return null;
	}

	public synchronized BigDecimal getNextUID(UserInfo ui, String tableName,
			String columnName) throws BaseException {
		Connection con = null;
		Statement st = null;
		try {
			con = dbPoolService.getConnection(ui.getName());
			st = con.createStatement();
			ResultSet rs = st.executeQuery("select uid_seq.nextval from dual");
			if (rs.next()) {
				BigDecimal uid = rs.getBigDecimal(1);
				fireSequenceNumCreateEvent(tableName, columnName, uid.toString());
				return uid;
			}
		} catch (Exception x) {
			log.error("", x);
			throw new BaseException(x);
		} finally {
			DBUtils.close(st);
			releaseConnection(con, ui);
		}
		return null;
	}

}