package clinical.web.services;

import java.math.BigDecimal;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import clinical.server.VisitInfo;
import clinical.server.dao.CollectionequipmentDAO;
import clinical.server.dao.ExpcomponentDAO;
import clinical.server.dao.ExpsegmentDAO;
import clinical.server.dao.RawdataDAO;
import clinical.server.vo.Collectionequipment;
import clinical.server.vo.Expcomponent;
import clinical.server.vo.Expsegment;
import clinical.server.vo.Rawdata;
import clinical.utils.Assertion;
import clinical.utils.GenUtils;
import clinical.web.DAOFactory;
import clinical.web.ISubjectVisitHandler;
import clinical.web.ServiceFactory;
import clinical.web.common.query.TSQLProcessor;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: SubjectVisitHandlerImpl.java,v 1.6 2006/04/19 01:17:03 bozyurt
 *          Exp $
 */

public class SubjectVisitHandlerImpl implements ISubjectVisitHandler {
	protected static SubjectVisitHandlerImpl instance;

	protected SubjectVisitHandlerImpl() {
	}

	public synchronized static SubjectVisitHandlerImpl getInstance() {
		if (instance == null)
			instance = new SubjectVisitHandlerImpl();
		return instance;
	}

	/**
	 *
	 * @param con
	 *            database connection
	 * @param subjectID
	 *            the BIRN ID of the subject to retrieve his/her visits
	 * @return a list of VisitInfo container objects
	 * @see clinical.server.VisitInfo
	 * @throws Exception
	 */
	public List<VisitInfo> getVisitInfos(String dbID, Connection con,
			String subjectID) throws Exception {
		Expcomponent criteria = new Expcomponent();
		criteria.setSubjectid(subjectID);

		// seems not necessary anymore IBO 2/13/08
		// ExpComponentDAOAdapter dao = new
		// ExpComponentDAOAdapter(availableTables);
		ExpcomponentDAO dao = DAOFactory.createExpcomponentDAO(dbID);

		Map<BigDecimal, Collectionequipment> collEquipMap = prepCollectionEquipmentMap(
				dbID, con);

		List<Expcomponent> visits = dao.find(con, criteria);
		List<VisitInfo> visitInfos = new LinkedList<VisitInfo>();
		Expsegment cr = new Expsegment();
		ExpsegmentDAO esDAO = DAOFactory.createExpsegmentDAO(dbID);
		cr.setSubjectid(subjectID);
		for (Expcomponent visit : visits) {
			VisitInfo vi = new VisitInfo(visit);
			cr.setComponentid(visit.getComponentid());
			List<Expsegment> segments = esDAO.find(con, cr);
			boolean scanVisit = GenUtils.isScanVisitType(visit.getVisittype());
			for (Expsegment es : segments) {
				vi.addSegment(es);
			}
			if ( scanVisit) {
               Map<BigDecimal, Rawdata> rdMap = getRawDataSegmentMap(dbID, con, segments);
               for (Expsegment es : segments) {
       			   Rawdata rd = rdMap.get(es.getUniqueid());
       			   if ( rd != null) {
       				Collectionequipment ce = collEquipMap.get(rd
							.getNcColequipmentUniqueid());
					if (ce != null)
						vi.setEquipment(es, ce);
       			   }
               }
            }
			visitInfos.add(vi);
		}

		return visitInfos;
	}

	protected Rawdata getRawDataForSegment(String dbID, Connection con,
			Expsegment segment) throws Exception {
		Rawdata criteria = new Rawdata();
		criteria.setComponentid(segment.getComponentid());
		criteria.setNcExperimentUniqueid(segment.getNcExperimentUniqueid());
		criteria.setSegmentid(segment.getSegmentid());
		criteria.setSubjectid(segment.getSubjectid());

		RawdataDAO dao = DAOFactory.createRawdataDAO(dbID);
		List<Rawdata> rawDatas = dao.find(con, criteria);
		if (rawDatas.isEmpty())
			return null;
		return rawDatas.get(0);
	}

	protected Map<BigDecimal, Rawdata> getRawDataSegmentMap(String dbID,
			Connection con, List<Expsegment> segments) throws Exception {
		Assertion.assertTrue(segments != null && !segments.isEmpty());
		Map<BigDecimal, Rawdata> map = new HashMap<BigDecimal, Rawdata>();
		Map<BigDecimal, Expsegment> segMap = new HashMap<BigDecimal, Expsegment>(17);
		for(Expsegment seg : segments)
			segMap.put(seg.getSegmentid(), seg);
		Expsegment seg = segments.get(0);
		StringBuilder sb = new StringBuilder(200);
		sb.append("select r.ncColequipmentUniqueid, r.segmentid from Rawdata as r ");
		sb.append("where r.componentid = ").append(seg.getComponentid());
		sb.append(" and r.ncExperimentUniqueid = ").append(
				seg.getNcExperimentUniqueid());
		sb.append(" and r.subjectid = '").append(seg.getSubjectid())
				.append("'");
		sb.append(" and r.segmentid in(").append(seg.getSegmentid());
		for (Iterator<Expsegment> it = segments.iterator(); it.hasNext();) {
			seg =  it.next();
			sb.append(seg.getSegmentid());
			if (it.hasNext()) sb.append(',');
		}
		sb.append(')');
		TSQLProcessor  tsql = new TSQLProcessor(ServiceFactory.getSQLDialect(dbID) );

		List<?> results = tsql.executeQuery(con, sb.toString());

		for (Object item : results) {
		    Rawdata rd = (Rawdata) item;
		    seg = segMap.get(rd.getSegmentid());
		    map.put(seg.getUniqueid(), rd);
		}
		return map;
	}

	protected Map<BigDecimal, Collectionequipment> prepCollectionEquipmentMap(
			String dbID, Connection con) throws Exception {
		Map<BigDecimal, Collectionequipment> map = new HashMap<BigDecimal, Collectionequipment>(
				11);
		Collectionequipment criteria = new Collectionequipment();
		CollectionequipmentDAO dao = DAOFactory
				.createCollectionequipmentDAO(dbID);
		List<Collectionequipment> lst = dao.find(con, criteria);
		for (Collectionequipment ce : lst) {
			map.put(ce.getUniqueid(), ce);
		}
		return map;
	}

}
