package clinical.web.upload;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import clinical.web.common.UserInfo;
import clinical.web.scheduler.IJob;
import clinical.web.scheduler.IJobEventListener;
import clinical.web.scheduler.IJobFactory;
import clinical.web.scheduler.JobException;
import clinical.web.scheduler.JobVisitContext;
import clinical.web.scheduler.remote.WFESLocation;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: UploadJob.java 537 2012-02-08 21:01:26Z bozyurt $
 */

public class UploadJob implements IJob {
	private String id;
	private UserInfo ui;
	private String description;
	private UploadContext ctx;
	protected List<IJobEventListener> listeners = new ArrayList<IJobEventListener>(
			1);
	protected String status;

	public UploadJob(String id, UserInfo ui, String description,
			UploadContext ctx) {
		this.id = id;
		this.ui = ui;
		this.description = description;
		this.ctx = ctx;
	}

	public synchronized void cancel() {

	}

	public int getNumberOfStages() {
		return 1;
	}

	public void execute(int stageId) throws JobException {
		UploadHandler uh = new UploadHandler(ctx, ui);
		for (UploadVisit uv : ctx.getVisits2Upload()) {
			try {
				uh.uploadVisit(uv);
			} catch (Exception e) {
				throw new JobException(e);
			}
		}
	}

	public String getDbID() {
		return null;
	}

	public String getDescription() {
		return description;
	}

	public String getID() {
		return id;
	}

	public String[] getResultsFiles() {
		return null;
	}

	public String getType() {
		return "CBF Image Upload";
	}

	public String getUser() {
		return ui.getPerceivedName();
	}

	public UserInfo getUserInfo() {
		return ui;
	}

	public void saveResults(File file) throws JobException {
		// noop
	}

	public int getDurationType() {
		return MEDIUM;
	}

	public void addJobEventListener(IJobEventListener listener) {
		listeners.add(listener);
	}

	public void shutdown() {
		listeners = null;
	}

	public synchronized boolean isCanceled() {
		return false;
	}

	public List<JobVisitContext> getJobVisitContextList() {
		return new ArrayList<JobVisitContext>(0);
	}

	public String getContextAsJSON() {
		return null;
	}

	@Override
	public IJobFactory getJobFactory() {
		throw new UnsupportedOperationException();
	}

	@Override
	public synchronized String getStatus() {
		return status;
	}

	@Override
	public synchronized void setStatus(String status) {
		this.status = status;
	}

	@Override
	public void cleanup() {
		// no op
	}

	@Override
	public boolean setWFESLocation(WFESLocation location) {
		return false;
	}
}
