package clinical.web.vo;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import clinical.server.vo.Extendedtuple;
import clinical.server.vo.Tuplecolumns;
import clinical.utils.Assertion;
import clinical.web.common.query.BinaryOperator;
import clinical.web.common.query.MGQueryPartInfo;
import clinical.web.common.query.Operator;
import clinical.web.common.query.QueryUtils;
import clinical.web.common.query.SearchPredicate;
import clinical.web.common.query.UnaryOperator;
import clinical.web.common.vo.AnalysisExTupleInfo;

/**
 * @author I. Burak Ozyurt
 * @version $Id: AnalysisResultQueryInfo.java,v 1.1.2.2 2008/06/16 23:56:02
 *          bozyurt Exp $
 */
public class AnalysisResultQueryInfo implements Serializable {
	private static final long serialVersionUID = 1L;
	protected Map<String, AnalysisExTupleInfo> anETIMap;
	protected Map<Integer, List<Tuplecolumns>> extTupleColsMap;
	protected Map<Integer, List<String>> extTuple2MeasGroupNameMap;
	protected List<MGQueryPartInfo> mgQPIList;

	public AnalysisResultQueryInfo() {
	}


	public List<MGQueryPartInfo> getQPIListForSite(List<Extendedtuple> etList) {
		List<MGQueryPartInfo> list = new ArrayList<MGQueryPartInfo>(mgQPIList.size());
		Map<String, Extendedtuple> etMap = new HashMap<String, Extendedtuple>(17);
		for(Extendedtuple et : etList)
			etMap.put(et.getName(), et);
		for(MGQueryPartInfo m : mgQPIList) {
			Extendedtuple et = etMap.get(m.getTqi().getExTupleName());
			if ( et != null) {
				MGQueryPartInfo qpi = new MGQueryPartInfo(m);
				qpi.getTqi().getCtdi().setExtendedTupleID(et.getUniqueid());
				list.add(qpi);
			} else {
				return null;
			}
		}
		return list;
	}

	public Operator prepareOpTree() {
		Operator root = null;
		BinaryOperator last = null;
		int noQParts = mgQPIList.size();
		boolean first = true;

		for (Iterator<MGQueryPartInfo> it = mgQPIList.iterator(); it.hasNext();) {
			MGQueryPartInfo qp = it.next();
			String connector = qp.getConnector();

			SearchPredicate.Range range = null;
			SearchPredicate.DateRange dateRange = null;
			SearchPredicate sp = null;

			int logOp = qp.getOperator();
			int spType = QueryUtils.getSearchPredicateType(qp.getVarType());

			Object value = null;
			if (qp.getRhs().trim().equals("*")) {
				value = qp.getRhs().trim();
			} else {
				value = QueryUtils.convertToType(qp.getRhs(), spType);
			}

			if (qp.getLowBound() != null && qp.getLowBound().length() > 0
					&& qp.getUppBound() != null
					&& qp.getUppBound().length() > 0) {

				Object v = QueryUtils.convertToType(qp.getLowBound(), spType);
				if (v instanceof Date) {
					Date lowBound = (Date) v;
					Date uppBound = (Date) QueryUtils.convertToType(qp
							.getUppBound(), spType);
					dateRange = new SearchPredicate.DateRange(lowBound,
							uppBound);
				} else {
					Number lowBound = (Number) QueryUtils.convertToType(qp
							.getLowBound(), spType);
					Number uppBound = (Number) QueryUtils.convertToType(qp
							.getUppBound(), spType);

					range = new SearchPredicate.Range(lowBound, uppBound);
				}
			}
			Object attribute = qp.getTqi();
			if (range != null) {
				sp = new SearchPredicate(attribute, range, logOp, spType);
			} else if (dateRange != null) {
				sp = new SearchPredicate(attribute, dateRange, logOp, spType);
			} else {
				sp = new SearchPredicate(attribute, value, logOp, spType);
			}

			if (noQParts == 1) {
				root = new UnaryOperator(sp, Operator.NONE);
			} else {
				if (first) {
					UnaryOperator uo = new UnaryOperator(sp, Operator.NONE);
					root = new BinaryOperator();
					((BinaryOperator) root).setLhs(uo);
					last = (BinaryOperator) root;
					first = false;
				} else {
					// do we have more query parts?
					if (it.hasNext()) {
						last.setLogicalOp(getSelectedConnector(connector));
						BinaryOperator bop = new BinaryOperator();
						UnaryOperator lhs = new UnaryOperator(sp, Operator.NONE);
						bop.setLhs(lhs);
						last.setRhs(bop);
						last = bop;
					} else {
						// the last one
						UnaryOperator uo = new UnaryOperator(sp, Operator.NONE);
						last.setLogicalOp(getSelectedConnector(connector));
						last.setRhs(uo);
					}
				}
			}
		}

		return root;
	}

	protected static int getSelectedConnector(String connector) {
		return (connector.equals("AND")) ? Operator.AND : Operator.OR;
	}

	public String getAsJSON() {
		JSONObject js;
		try {
			js = toJSON();
			return js.toString(2);
		} catch (JSONException e) {
			e.printStackTrace();
		}
		return "{}";
	}

	public JSONObject toJSON() throws JSONException {
		JSONObject js = new JSONObject();
		if (mgQPIList != null) {
			JSONArray jsArr = new JSONArray();
			for (MGQueryPartInfo qp : this.mgQPIList) {
				jsArr.put(qp.toJSON(new JSONObject()));
			}
			js.put("mgQPIList", jsArr);
		}
		JSONArray arr = new JSONArray();
		List<String> anNames = new ArrayList<String>(anETIMap.keySet());
		Collections.sort(anNames);
		for (String an : anNames) {
			arr.put(an);
		}
		js.put("analysisNames", arr);
		JSONArray arr2 = new JSONArray();
		for(String anName :  anNames) {
			AnalysisExTupleInfo aeti = anETIMap.get(anName);
			arr2.put(aeti.toJSON());
		}

		js.put("aetiList", arr2);
		JSONArray etcArr = new JSONArray();
		for (Map.Entry<Integer, List<Tuplecolumns>> entry : extTupleColsMap
				.entrySet()) {
			int etID = entry.getKey();
			List<Tuplecolumns> tcList = entry.getValue();
			JSONObject jso = new JSONObject();
			jso.put("etID", etID);
			JSONArray arr3 = new JSONArray();
			for (Tuplecolumns tc : tcList) {
				JSONObject o = new JSONObject();
				o.put("colName", tc.getColumnname());
				o.put("colType", tc.getColumntype());
				o.put("unit", tc.getMeasurementunit());
				o.put("measureSystem", tc.getMeasurementsystem());
				arr3.put(o);
			}
			jso.put("tupleCols", arr3);
			etcArr.put(jso);
		}
		js.put("extTupleColsList", etcArr);

		JSONArray et2MGNArr = new JSONArray();
		for (Map.Entry<Integer, List<String>> entry : extTuple2MeasGroupNameMap
				.entrySet()) {
			int etID = entry.getKey();
			List<String> mgNameList = entry.getValue();
			JSONObject jso = new JSONObject();
			jso.put("etID", etID);
			JSONArray arr3 = new JSONArray();
			for (String mgName : mgNameList) {
				arr3.put(mgName);
			}
			jso.put("measGroupNames", arr3);
			et2MGNArr.put(jso);
		}
		js.put("extTuple2MGNameList", et2MGNArr);

		return js;
	}

	public static AnalysisResultQueryInfo initializeFromJSON(JSONObject js)
			throws JSONException {
		AnalysisResultQueryInfo arqi = new AnalysisResultQueryInfo();
		JSONArray jsArr = js.getJSONArray("mgQPIList");
		arqi.mgQPIList = new ArrayList<MGQueryPartInfo>(jsArr.length());
		for (int i = 0; i < jsArr.length(); i++) {
			JSONObject json = jsArr.getJSONObject(i);
			MGQueryPartInfo mgqpi = MGQueryPartInfo.initializeFromJSON(json);
			arqi.mgQPIList.add(mgqpi);
		}
		return arqi;
	}

	public void updateQueryFromJSON(JSONObject js) throws JSONException {
		JSONArray jsArr = js.getJSONArray("mgQPIList");
		mgQPIList = new ArrayList<MGQueryPartInfo>(jsArr.length());
		for (int i = 0; i < jsArr.length(); i++) {
			JSONObject json = jsArr.getJSONObject(i);
			MGQueryPartInfo mgqpi = MGQueryPartInfo.initializeFromJSON(json);
			mgQPIList.add(mgqpi);
		}

	}

	public JSONArray queryToJSON() throws JSONException {
		Assertion.assertTrue(mgQPIList != null && !mgQPIList.isEmpty());
		JSONArray jsArr = new JSONArray();
		for (MGQueryPartInfo mgqpi : mgQPIList) {
			jsArr.put(mgqpi.toJSON(new JSONObject()));
		}
		return jsArr;
	}

	public Map<String, AnalysisExTupleInfo> getAnETIMap() {
		return anETIMap;
	}

	public Map<Integer, List<Tuplecolumns>> getExtTupleColsMap() {
		return extTupleColsMap;
	}

	public Map<Integer, List<String>> getExtTuple2MeasGroupNameMap() {
		return extTuple2MeasGroupNameMap;
	}

	public List<MGQueryPartInfo> getMgQPIList() {
		return mgQPIList;
	}

	public void setAnETIMap(Map<String, AnalysisExTupleInfo> anETIMap) {
		this.anETIMap = anETIMap;
	}

	public void setExtTupleColsMap(
			Map<Integer, List<Tuplecolumns>> extTupleColsMap) {
		this.extTupleColsMap = extTupleColsMap;
	}

	public void setExtTuple2MeasGroupNameMap(
			Map<Integer, List<String>> extTuple2MeasGroupNameMap) {
		this.extTuple2MeasGroupNameMap = extTuple2MeasGroupNameMap;
	}


	public void setMgQPIList(List<MGQueryPartInfo> mgQPIList) {
		this.mgQPIList = mgQPIList;
	}
}
