package clinical.web.vo;

import java.io.Serializable;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id$
 */
public class CBFQueryResultSummary implements Serializable {
	private static final long serialVersionUID = 1L;
	private String subjectID;
	private String expID;
	private AssessmentResultSummary ars;
	private ProvenanceResultSummary prs;
	private JobResultResultSummary jrs;

	public CBFQueryResultSummary(String subjectID, String expID) {
		this.subjectID = subjectID;
		this.expID = expID;
	}

	public String getSubjectID() {
		return subjectID;
	}

	public String getExpID() {
		return expID;
	}

	public AssessmentResultSummary getArs() {
		return ars;
	}

	public void setArs(AssessmentResultSummary ars) {
		this.ars = ars;
	}

	public ProvenanceResultSummary getPrs() {
		return prs;
	}

	public void setPrs(ProvenanceResultSummary prs) {
		this.prs = prs;
	}

	public JobResultResultSummary getJrs() {
		return jrs;
	}

	public void setJrs(JobResultResultSummary jrs) {
		this.jrs = jrs;
	}

	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder(1028);
		sb.append("CBFQueryResultSummary::[");
		sb.append("subjectID=").append(subjectID);
		sb.append(",expID=").append(expID);
		if (ars != null) {
			sb.append("\n\t").append(ars);
		}
		if (prs != null) {
			sb.append("\n\t").append(prs);
		}
		if (jrs != null) {
			sb.append("\n\t").append(jrs);
		}
		sb.append(']');
		return sb.toString();
	}

}
