package clinical.web.vo;

import java.util.ArrayList;
import java.util.List;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import clinical.web.vo.JobProvenanceInfo.JobProvenanceParamType;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id$
 */
public class JobProvenanceMetadata {
	private List<JobProvParamMetadata> params = new ArrayList<JobProvParamMetadata>(
			10);

	public JobProvenanceMetadata() {
	}

	public void add(String paramName, JobProvenanceParamType paramType) {
		params.add(new JobProvParamMetadata(paramName, paramType));
	}

	public List<JobProvParamMetadata> getParams() {
		return params;
	}
	
	public JSONObject toJSON() throws JSONException {
		JSONObject js = new JSONObject();
		JSONArray jsArr = new JSONArray();
		js.put("params", jsArr);
		for(JobProvParamMetadata pm : params) {
			jsArr.put( pm.toJSON());
		}
		return js;
	}

	public static class JobProvParamMetadata {
		private String name;
		private JobProvenanceInfo.JobProvenanceParamType paramType;

		public JobProvParamMetadata(String name, JobProvenanceParamType paramType) {
			super();
			this.name = name;
			this.paramType = paramType;
		}

		public String getName() {
			return name;
		}

		public JobProvenanceInfo.JobProvenanceParamType getParamType() {
			return paramType;
		}
		
		public JSONObject toJSON() throws JSONException {
			JSONObject js = new JSONObject();
			js.put("name", name);
			js.put("type", paramType.toString());
			return js;
		}

	}

}
