package clinical.web.vo;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id$
 */
public class JobResultResultSummary implements Serializable {
	private static final long serialVersionUID = 1L;
	private String subjectID;
	private String expID;
	private String expName = "unknown";
	private Map<String, VisitJobResultValues> vjrvMap = new LinkedHashMap<String, JobResultResultSummary.VisitJobResultValues>(
			3);

	public JobResultResultSummary(String subjectID, String expID, String expName) {
		super();
		this.subjectID = subjectID;
		this.expID = expID;
		this.expName = expName;
	}


	
	public String getSubjectID() {
		return subjectID;
	}

	public String getExpID() {
		return expID;
	}

	public String getExpName() {
		return expName;
	}

	public Map<String, VisitJobResultValues> getVjrvMap() {
		return vjrvMap;
	}

	public String getKey() {
		StringBuilder sb = new StringBuilder();
		sb.append(subjectID).append(':').append(expID);
		return sb.toString();
	}

	public VisitJobResultValues getOrAdd(int visitID, int experimentID,
			int jobResultGroupID) {
		if (!this.expID.equals( String.valueOf(experimentID) )) {
			throw new RuntimeException("Invalid expID:" + experimentID
					+ " Expected:" + this.expID);
		}
		String key = prepVisitJobResultValuesKey(visitID, experimentID,
				jobResultGroupID);
		VisitJobResultValues vjrv = vjrvMap.get(key);
		if (vjrv == null) {
			vjrv = new VisitJobResultValues(visitID, experimentID,
					jobResultGroupID);
			vjrvMap.put(key, vjrv);
		}
		return vjrv;
	}

	public VisitJobResultValues get(int visitID, int experimentID,
			int jobResultGroupID) {
		String key = prepVisitJobResultValuesKey(visitID, experimentID,
				jobResultGroupID);
		return vjrvMap.get(key);
	}

	public static String prepVisitJobResultValuesKey(int visitID,
			int experimentID, int jobResultGroupID) {
		StringBuilder sb = new StringBuilder();
		sb.append(experimentID).append(':').append(visitID).append(':')
				.append(jobResultGroupID);
		return sb.toString();
	}
	
	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder(512);
		sb.append("JobResultResultSummary::[");
		sb.append("subjectID=").append(subjectID);
		sb.append(",expID=").append(expID);
		sb.append(",expName=").append(expName);
		for(VisitJobResultValues vjrv : vjrvMap.values() ) {
			sb.append("\n\t").append(vjrv);
		}
		sb.append(']');		
		return sb.toString();
	}

	public static class VisitJobResultValues implements Serializable {
		private static final long serialVersionUID = 1L;
		private int visitID;
		private int expID;
		private int jobResultGroupID;
		private Map<String, JobResultValueSummary> jrvsMap = new LinkedHashMap<String, JobResultValueSummary>(
				5);

		public VisitJobResultValues(int visitID, int expID, int jobResultGroupID) {
			super();
			this.visitID = visitID;
			this.expID = expID;
			this.jobResultGroupID = jobResultGroupID;
		}

		public int getVisitID() {
			return visitID;
		}

		public int getExpID() {
			return expID;
		}

		public Map<String, JobResultValueSummary> getJrvsMap() {
			return jrvsMap;
		}

		public int getJobResultGroupID() {
			return jobResultGroupID;
		}

		public void add(JobResultValueSummary jvs) {
			StringBuilder sb = new StringBuilder();
			sb.append(jvs.getName()).append(':').append(jvs.getGroupID());
			String key = sb.toString();
			jrvsMap.put(key, jvs);
		}
		
		@Override
		public String toString() {
			StringBuilder sb = new StringBuilder(256);
			sb.append("JobResultValueSummary::[");
			sb.append("expID=").append(expID);
			sb.append(",visitID=").append(visitID);
			sb.append(",jobResultGroupID=").append(jobResultGroupID);
			for(JobResultValueSummary jrvs : jrvsMap.values()) {
			      sb.append("\n\t").append(jrvs);	
			}
			sb.append(']');
			return sb.toString();
		}

	}

	

}
