package clinical.web.vo;

import org.json.JSONException;
import org.json.JSONObject;

import clinical.web.workflow.common.JSONUtils;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id$
 */
public class JobResultTypeInfo {
	private String name;
	private String group;
	private String description;
	private String unit;
	private ResultType type;

	public static enum ResultType {
		STRING, INT, FLOAT, BOOL,
	}

	public JobResultTypeInfo(String name, String group, String description,
			String unit, ResultType type) {
		this.name = name;
		this.group = group;
		this.description = description;
		this.unit = unit;
		this.type = type;
	}

	public String getName() {
		return name;
	}

	public String getDescription() {
		return description;
	}

	public String getUnit() {
		return unit;
	}

	public ResultType getType() {
		return type;
	}

	public String getGroup() {
		return group;
	}

	public JSONObject toJSON(JSONObject js) throws JSONException {
		js.put("name", name);
		js.put("group", group);
		JSONUtils.addStringField(js, "descr", description, "");
		JSONUtils.addStringField(js, "unit", unit, "");
		js.put("type", type.toString());
		return js;
	}

	public static JobResultTypeInfo initializeFromJSON(JSONObject js)
			throws JSONException {
		String name = js.getString("name");
		String group = js.getString("group");
		String descr = js.getString("descr");
		String unit = js.getString("unit");
		ResultType type = ResultType.valueOf(js.getString("type"));

		return new JobResultTypeInfo(name, group, descr, unit, type);
	}

	@Override
	public String toString() {
		return "JobResultTypeInfo [name=" + name + ", group=" + group
				+ ", description=" + description + ", unit=" + unit + ", type="
				+ type + "]";
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((group == null) ? 0 : group.hashCode());
		result = prime * result + ((name == null) ? 0 : name.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		JobResultTypeInfo other = (JobResultTypeInfo) obj;
		if (group == null) {
			if (other.group != null)
				return false;
		} else if (!group.equals(other.group))
			return false;
		if (name == null) {
			if (other.name != null)
				return false;
		} else if (!name.equals(other.name))
			return false;
		return true;
	}

	

}
