package clinical.web.vo;

import java.io.Serializable;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import clinical.utils.Assertion;
import clinical.web.common.query.QueryPartInfo;
import clinical.web.common.vo.AsScoreInfo;
import clinical.web.common.vo.AssessmentSelectionInfo;

/**
 * A wrapper class for holding assessment and analysis query info.
 *
 * @author I. Burak Ozyurt
 * @version $Id: QueryInfo.java 366 2011-05-05 20:06:27Z bozyurt $
 */
public class QueryInfo implements Serializable {
	private static final long serialVersionUID = 1L;
	protected AssessmentQueryInfo aqi;
	protected AnalysisResultQueryInfo arqi;
	protected String expIDStr;

	public QueryInfo(AnalysisResultQueryInfo arqi) {
		super();
		this.arqi = arqi;
	}

	public QueryInfo(AssessmentQueryInfo aqi) {
		super();
		this.aqi = aqi;
	}

	/**
	 * if a query information is available set the selected state of the
	 * involved assessment and scores.
	 */
	public void prepareStoredQuery() {
		if (aqi != null && aqi.hasQueryParts()) {
			aqi.resetAllSelected();
			for (QueryPartInfo qpi : aqi.getQpiList()) {
				AssessmentSelectionInfo asi = aqi.findAsi(qpi.getAsi()
						.getAssessmentID());
				asi.setSelected(true);
				AsScoreInfo si = asi
						.findScoreInfo(qpi.getScoreInfo().getName());
				si.setSelected(true);
				if (qpi.getRhs() != null)
					si.setRhsValue(qpi.getRhs());
				si.setOperatorCode( qpi.getOperator() );
			}
		}
	}

	public AssessmentQueryInfo getAqi() {
		return aqi;
	}

	public void setAqi(AssessmentQueryInfo aqi) {
		this.aqi = aqi;
	}

	public AnalysisResultQueryInfo getArqi() {
		return arqi;
	}

	public void setArqi(AnalysisResultQueryInfo arqi) {
		this.arqi = arqi;
	}

	public JSONObject queryToJSON(String expID) throws JSONException {
		JSONObject js = new JSONObject();
		if (expID != null) {
			js.put("expId", expID);
			expIDStr = expID;
		}
		if (aqi != null) {
			JSONArray jsArr = aqi.queryToJSON();
			js.put("asQPIList", jsArr);
		}
		if (arqi != null) {
			JSONArray jsArr = arqi.queryToJSON();
			js.put("mgQPIList", jsArr);
		}
		return js;
	}

	public void jsonToQuery(JSONObject js) throws JSONException {
		expIDStr = js.getString("expId");
		if (js.has("asQPIList")) {
			Assertion.assertNotNull(aqi);
			aqi.updateQueryFromJSON(js);
		}
		if (js.has("mgQPIList")) {
			if (arqi == null) {
				arqi = AnalysisResultQueryInfo.initializeFromJSON(js);
			} else {
				arqi.updateQueryFromJSON(js);
			}
		}
	}

	public String getExpIDStr() {
		return expIDStr;
	}

}
