package clinical.web.vo;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: SegmentScoreValuesSummary.java,v 1.1 2005/11/09 20:58:13
 *          bozyurt Exp $
 */
public class SegmentScoreValuesSummary {
	private String subjectID;
	private int visitID;
	private int segmentID;
	private int experimentID;
	private String siteID;
	private Map<String, SubjectAsScoreValueSummary> map = new LinkedHashMap<String, SubjectAsScoreValueSummary>();

	public SegmentScoreValuesSummary(String subjectID, int visitID,
			int segmentID, int experimentID, String siteID) {
		this.subjectID = subjectID;
		this.visitID = visitID;
		this.segmentID = segmentID;
		this.experimentID = experimentID;
		this.siteID = siteID;
	}

	public static String prepareKey(String subjectID, int visitID,
			int segmentID, int experimentID, String siteID) {
		StringBuffer buf = new StringBuffer(80);
		buf.append(subjectID).append('_').append(siteID).append('_');
		buf.append(experimentID).append('_').append(visitID).append('_');
		buf.append(segmentID);
		return buf.toString();
	}

	public String getSubjectID() {
		return this.subjectID;
	}

	public int getVisitID() {
		return this.visitID;
	}

	public int getSegmentID() {
		return this.segmentID;
	}

	public int getExperimentID() {
		return this.experimentID;
	}

	public String getSiteID() {
		return this.siteID;
	}

	public void addScoreValueSummary(SubjectAsScoreValueSummary sasv) {
		assert (sasv.getExperimentID() == experimentID && sasv.getSiteID() == siteID);
		String key = prepareKey(sasv.getAssessmentID(), sasv.getScoreName());
		map.put(key, sasv);
	}

	public SubjectAsScoreValueSummary get(String asID, String scoreName) {
		String key = prepareKey(asID, scoreName);
		return map.get(key);
	}

	public List<SubjectAsScoreValueSummary> getSubjectAsScoreValueSummaryList() {
		return new ArrayList<SubjectAsScoreValueSummary>(map.values());
	}

	public static String prepareKey(String asID, String scoreName) {
		StringBuffer buf = new StringBuffer();
		buf.append(asID).append('_').append(scoreName);
		return buf.toString();
	}

	public boolean equals(Object other) {
		if (other == null)
			return false;
		if (other == this)
			return true;
		if (!(other instanceof SegmentScoreValuesSummary)) {
			return false;
		}
		SegmentScoreValuesSummary that = (SegmentScoreValuesSummary) other;
		if ((subjectID != null && that.subjectID != null && subjectID
				.equals(that.subjectID))
				&& visitID == that.visitID
				&& segmentID == that.segmentID
				&& experimentID == that.experimentID
				&& (siteID != null && that.siteID != null && siteID
						.equals(that.siteID))) {
			return true;
		}
		return false;
	}

	public int hasCode() {
		if (subjectID != null && siteID != null) {
			int result = 14;
			result = 29 * result + subjectID.hashCode();
			result = 29 * result + visitID;
			result = 29 * result + segmentID;
			result = 29 * result + experimentID;
			result = 29 * result + siteID.hashCode();
			return result;
		} else {
			return System.identityHashCode(this);
		}
	}

	public String toString() {
		StringBuffer buf = new StringBuffer(152);
		buf.append("SegmentScoreValuesSummary::[");
		buf.append("subjectID=").append(subjectID);
		buf.append(", visitID=").append(visitID);
		buf.append(", segmentID=").append(segmentID);
		buf.append(", experimentID=").append(experimentID);
		buf.append(", siteID=").append(siteID);
		buf.append(']');
		return buf.toString();
	}
}
