package clinical.web.vo;

import java.util.ArrayList;
import java.util.List;

import clinical.server.vo.Jobs;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id$
 */
public class StoredJobResultGroupInfo {
	private JobResultGroupInfo jobResultGroup;
	private JobProvenanceInfo jobProvInfo;
	private Jobs job;
	private Integer expID;
	private String subjectID;
	private Integer visitID;
	private List<JobResultInfo> results = new ArrayList<JobResultInfo>(10);

	public StoredJobResultGroupInfo(JobResultGroupInfo jobResultGroup,
			JobProvenanceInfo jobProvInfo, Jobs job, Integer expID,
			String subjectID, Integer visitID) {
		super();
		this.jobResultGroup = jobResultGroup;
		this.jobProvInfo = jobProvInfo;
		this.job = job;
		this.expID = expID;
		this.subjectID = subjectID;
		this.visitID = visitID;
	}

	public void addResult(JobResultInfo jri) {
		results.add(jri);
	}

	public JobResultGroupInfo getJobResultGroup() {
		return jobResultGroup;
	}

	public JobProvenanceInfo getJobProvInfo() {
		return jobProvInfo;
	}

	public Jobs getJob() {
		return job;
	}

	public List<JobResultInfo> getResults() {
		return results;
	}

	public Integer getExpID() {
		return expID;
	}

	public String getSubjectID() {
		return subjectID;
	}

	public Integer getVisitID() {
		return visitID;
	};

	public String toString() {
		StringBuilder sb = new StringBuilder(256);
		sb.append("StoredJobResultGroupInfo::[");
		sb.append("expID:").append(expID);
		sb.append(",subjectID:").append(subjectID);
		sb.append(",visitID:").append(visitID);
		sb.append("jobResultGroup:").append(jobResultGroup);
		sb.append("\n,jobProvInfo:").append(jobProvInfo);
		sb.append("\n,job:").append(job);
		for (JobResultInfo jri : results) {
			sb.append("\n\t").append(jri);
		}
		sb.append(']');
		return sb.toString();
	}
}
