package clinical.web.vo;

import java.util.ArrayList;
import java.util.List;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SynonymInfo {
	Integer scoreSynonymId;
	String scoreName;
	String assessmentName;
	String synonyms;
	String canonicalValue;
	List<String> expNames = new ArrayList<String>(1);

	public SynonymInfo(Integer scoreSynonymId, String scoreName,
			String assessmentName, String synonyms, String canonicalValue) {
		super();
		this.scoreSynonymId = scoreSynonymId;
		this.scoreName = scoreName;
		this.assessmentName = assessmentName;
		this.synonyms = synonyms;
		this.canonicalValue = canonicalValue;
	}

	public void addExpName(String expName) {
		expNames.add(expName);
	}

	public Integer getScoreSynonymId() {
		return scoreSynonymId;
	}

	public String getScoreName() {
		return scoreName;
	}

	public String getAssessmentName() {
		return assessmentName;
	}

	public String getSynonyms() {
		return synonyms;
	}

	public List<String> getExpNames() {
		return expNames;
	}

	public String[] getSynonymArray() {
		return synonyms.split(";");
	}

	public boolean matchesAny(String scoreValue) {
		String[] sarr = getSynonymArray();
		for (String syn : sarr) {
			if (scoreValue.equals(syn)) {
				return true;
			}
		}
		return false;
	}

	public JSONObject toJSON() throws JSONException {
		JSONObject js = new JSONObject();
		js.put("id", scoreSynonymId);
		js.put("scoreName", scoreName);
		js.put("assessmentName", assessmentName);
		js.put("synonyms", synonyms);
		JSONArray jsArr = new JSONArray();
		js.put("expNames", jsArr);
		for (String expName : expNames) {
			jsArr.put(expName);
		}
		js.put("canonicalValue", canonicalValue);
		return js;
	}

	public String getCanonicalValue() {
		return canonicalValue;
	}

}
