package clinical.web.vo;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import clinical.server.vo.Experiment;
import clinical.server.vo.Publication;
import clinical.server.vo.UsageData;

public class UsageInfo implements Serializable{
	private static final long serialVersionUID = 1L;
	protected UsageData usageData;
	protected List<Publication> references;
	protected Experiment experiment;
	
	public UsageInfo(Experiment experiment) {
		usageData = new UsageData();
		references = new ArrayList<Publication>(1);
		this.experiment = experiment;
	}

	public UsageData getUsageData() {
		return usageData;
	}

	public List<Publication> getReferences() {
		return references;
	}

	public void addReference(Publication pub) {
		this.references.add(pub);
	}

	public Experiment getExperiment() {
		return experiment;
	}

	public void setUsageData(UsageData usageData) {
		this.usageData = usageData;
	}
}
