package clinical.web.vo.upload;

import java.io.Serializable;
import java.text.ParseException;

import org.json.JSONException;
import org.json.JSONObject;

public class BugReportInfo implements Serializable {
	String subjectID;
	int expId;
	int visitId;
	String reportingUser;
	String comments;
	private static final long serialVersionUID = 1L;

	public BugReportInfo(String subjectID, int expId, int visitId,
			String reportingUser, String comments) {
		super();
		this.subjectID = subjectID;
		this.expId = expId;
		this.visitId = visitId;
		this.reportingUser = reportingUser;
		this.comments = comments;
	}

	public String getSubjectID() {
		return subjectID;
	}

	public int getExpId() {
		return expId;
	}

	public int getVisitId() {
		return visitId;
	}

	public String getReportingUser() {
		return reportingUser;
	}

	public String getComments() {
		return comments;
	}

	public JSONObject toJSON() throws JSONException {
		JSONObject js = new JSONObject();
		js.put("subjectID", subjectID);
		js.put("expId", expId);
		js.put("visitId", visitId);
		js.put("reportingUser", reportingUser);
		js.put("comments", comments);
		return js;
	}
	
	public static BugReportInfo initializeFromJSON(JSONObject js)
			throws JSONException, ParseException {
		int visitId = js.getInt("visitId");
		String subjectID = js.getString("subjectID");
		int expId = js.getInt("expId");
		String reportingUser = js.getString("reportingUser");
		String comments = js.getString("comments");

		BugReportInfo bri = new BugReportInfo(subjectID, expId, visitId,
				reportingUser, comments);
		return bri;
	}
	
	public String toString() {
		StringBuilder sb = new StringBuilder();
		sb.append("BugReportInfo::[");
		sb.append("subjectID:").append(subjectID);
		sb.append(",expId:").append(expId);
		sb.append(",visitId:").append(visitId);
		sb.append(",reportingUser:").append(reportingUser);
		sb.append("\ncomments:").append(comments);
		sb.append("]");
		return sb.toString();
	}
}
