package clinical.web.vo.upload;

import java.io.Serializable;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: ColEquipInfo.java 366 2011-05-05 20:06:27Z bozyurt $
 */
public class ColEquipInfo implements Serializable {
	private static final long serialVersionUID = 1L;
	int id;
	String make;
	String model;

	public ColEquipInfo(int id, String make, String model) {
		super();
		this.id = id;
		this.make = make;
		this.model = model;
	}

	public int getId() {
		return id;
	}

	public String getMake() {
		return make;
	}

	public String getModel() {
		return model;
	}

	public JSONObject toJSON() throws JSONException {
		JSONObject js = new JSONObject();
		js.put("id", id);
		js.put("make", make);
		js.put("model", model);
		return js;
	}

	public static ColEquipInfo initializeFromJSON(JSONObject js)
			throws JSONException {
		int id = js.getInt("id");
		String make = js.getString("make");
		String model = js.getString("model");
		ColEquipInfo cei = new ColEquipInfo(id, make, model);
		return cei;

	}
}
