package clinical.web.vo.upload;

import java.io.Serializable;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: ProtocolInfo.java 366 2011-05-05 20:06:27Z bozyurt $
 */
public class ProtocolInfo implements Serializable {
	private static final long serialVersionUID = 1L;
	int version;
	String protocolId;
	String name;
	String descr;

	public ProtocolInfo(int version, String protocolId, String name, String descr) {
		super();
		this.version = version;
		this.protocolId = protocolId;
		this.name = name;
		this.descr = descr;
	}

	public int getVersion() {
		return version;
	}

	public String getProtocolId() {
		return protocolId;
	}

	public String getName() {
		return name;
	}

	public String getDescr() {
		return descr;
	}

	public JSONObject toJSON() throws JSONException {
		JSONObject js = new JSONObject();
		js.put("name", name);
		js.put("descr", descr);
		js.put("version", version);
		js.put("protocolId", protocolId);
		return js;
	}

	public static ProtocolInfo initializeFromJSON(JSONObject js)
			throws JSONException {
		String name = js.getString("name");
		String descr = null;
		if (js.has("descr")) {
			descr = js.getString("descr");
		}
		int version = js.getInt("version");
		String protocolId = js.getString("protocolId");
		ProtocolInfo pi = new ProtocolInfo(version, protocolId, name, descr);
		return pi;
	}

}
