package clinical.web.vo.upload;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: SegmentInfo.java 773 2013-03-02 00:14:00Z bozyurt $
 */
public class SegmentInfo implements Serializable {
	private static final long serialVersionUID = 1L;
	String name;
	String descr;
	int segmentId;
	int protocolVersion;
	String protocolId;
	Integer colEqId;
	Date timestamp;
	SeriesHeaderInfo shi;
	static SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy hh:mm");

	public SegmentInfo(String name, String descr, int protocolVersion,
			String protocolId, Integer colEqId, Date timestamp,
			SeriesHeaderInfo shi) {
		super();
		this.name = name;
		this.descr = descr;
		this.protocolVersion = protocolVersion;
		this.protocolId = protocolId;
		this.colEqId = colEqId;
		this.timestamp = timestamp;
		this.shi = shi;
	}

	public String getName() {
		return name;
	}

	public String getDescr() {
		return descr;
	}

	public int getProtocolVersion() {
		return protocolVersion;
	}

	public String getProtocolId() {
		return protocolId;
	}

	public Integer getColEqId() {
		return colEqId;
	}

	public Date getTimestamp() {
		return timestamp;
	}

	public JSONObject toJSON() throws JSONException {
		JSONObject js = new JSONObject();
		js.put("name", name);
		js.put("descr", descr);
		js.put("protocolId", protocolId);
		js.put("protocolVersion", protocolVersion);
		js.put("colEqId", colEqId.intValue());
		if (timestamp != null) {
			js.put("timestamp", sdf.format(timestamp));
		} else {
			js.put("timestamp", "");
		}
		js.put("shi", shi.toJSON());
		return js;
	}

	public static String getField(JSONObject js, String fieldName)
			throws JSONException {
		if (js.has(fieldName)) {
			return js.getString(fieldName);
		}
		return null;
	}

	public static SegmentInfo initializeFromJSON(JSONObject js)
			throws JSONException, ParseException {
		String name = js.getString("name");
		String descr = getField(js, "descr");
		String protocolId = js.getString("protocolId");
		int version = js.getInt("protocolVersion");
		int colEqId = js.getInt("colEqId");
		String s = js.getString("timestamp");
		Date ts = null;
		if (s.indexOf("/") != -1) {
			ts = sdf.parse(s);
		}
		SeriesHeaderInfo shi = SeriesHeaderInfo.fromJSON(js
				.getJSONObject("shi"));

		SegmentInfo si = new SegmentInfo(name, descr, version, protocolId,
				colEqId, ts, shi);
		return si;
	}

	public static SegmentInfo initializeFromJSON(JSONObject js,
			SeriesHeaderInfo shi) throws JSONException, ParseException {
		String name = js.getString("name");
		String descr = getField(js, "descr");
		String protocolId = js.getString("protocolId");
		int version = js.getInt("protocolVersion");
		int colEqId = js.getInt("colEqId");
		String s = js.getString("timestamp");
		Date ts = null;
		if (s.indexOf("/") != -1) {
			ts = sdf.parse(s);
		}
		// SeriesHeaderInfo shi =
		// SeriesHeaderInfo.fromJSON(js.getJSONObject("shi"));

		SegmentInfo si = new SegmentInfo(name, descr, version, protocolId,
				colEqId, ts, shi);
		return si;
	}

	public SeriesHeaderInfo getShi() {
		return shi;
	}

	public String toString() {
		StringBuilder sb = new StringBuilder();
		sb.append("SegmentInfo::[");
		sb.append("name:").append(name);
		sb.append(",protocolId:").append(protocolId);
		sb.append(",timestamp:").append(timestamp);
		sb.append(",segmentId:").append(segmentId);
		if (shi != null) {
			sb.append(",shi:").append(shi);
		}
		sb.append("]");
		return sb.toString();
	}

	public int getSegmentId() {
		return segmentId;
	}

	public void setSegmentId(int segmentId) {
		this.segmentId = segmentId;
	}
	
}
