package clinical.web.vo.upload;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import clinical.server.vo.UploadStatus;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: UploadStatusInfo.java 783 2013-03-15 23:01:31Z bozyurt $
 */
public class UploadStatusInfo {
	private UploadStatus uploadStatus;
	private List<SeriesHeaderInfo> shiList;
	private String stagingId;
	/** Additional files besides image series to be uploaded */
	private List<String> extraFiles = new ArrayList<String>(1);
	private String scannerInfo;

	public UploadStatusInfo(UploadStatus uploadStatus,
			List<SeriesHeaderInfo> shiList, List<String> extraFiles, String scannerInfo) {
		super();
		this.uploadStatus = uploadStatus;
		this.shiList = shiList;
		this.stagingId = String.valueOf(uploadStatus.getUniqueid().intValue());
		this.extraFiles = extraFiles;
		this.scannerInfo = scannerInfo;
	}

	public UploadStatusInfo() {
	}

	public UploadStatus getUploadStatus() {
		return uploadStatus;
	}

	public List<SeriesHeaderInfo> getShiList() {
		return shiList;
	}

	public String getStagingId() {
		return stagingId;
	}

	public JSONObject toJSONMinimal() throws JSONException {
		JSONObject js = new JSONObject();
		js.put("stagingId", uploadStatus.getUniqueid().intValue());
		JSONArray arr = new JSONArray();
		for (SeriesHeaderInfo shi : shiList) {
			JSONObject json = shi.toJSONNoImages();
			arr.put(json);
		}
		js.put("shiList", arr);
		if (scannerInfo != null) {
			js.put("scannerInfo", scannerInfo);
		}

		return js;
	}
	
	public JSONObject toJSON() throws JSONException {
		JSONObject js = new JSONObject();
		
		js.put("stagingId", uploadStatus.getUniqueid().intValue());
		JSONArray arr = new JSONArray();
		for (SeriesHeaderInfo shi : shiList) {
			JSONObject json = shi.toJSON();
			arr.put(json);
		}
		js.put("shiList", arr);

		JSONArray jsArr = new JSONArray();
		for (String f : extraFiles) {
			jsArr.put(f);
		}
		js.put("extraFiles", jsArr);
		if (scannerInfo != null) {
			js.put("scannerInfo", scannerInfo);
		}

		return js;
	}

	public static UploadStatusInfo fromJSON(JSONObject js)
			throws JSONException, ParseException {
		UploadStatusInfo usi = new UploadStatusInfo();
		usi.stagingId = js.getString("stagingId");
		JSONArray arr = js.getJSONArray("shiList");
		usi.shiList = new ArrayList<SeriesHeaderInfo>(arr.length());
		for (int i = 0; i < arr.length(); i++) {
			JSONObject json = arr.getJSONObject(i);
			usi.shiList.add(SeriesHeaderInfo.fromJSON(json));
		}

		arr = js.getJSONArray("extraFiles");
		for (int i = 0; i < arr.length(); i++) {
			usi.extraFiles.add(arr.getString(i));
		}
		if (js.has("scannerInfo")) {
			usi.scannerInfo = js.getString("scannerInfo");
		}
		return usi;
	}

	public List<String> getExtraFiles() {
		return extraFiles;
	}

	public String getScannerInfo() {
		return scannerInfo;
	}

}
