package clinical.web.workflow.cbf;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

import clinical.utils.Assertion;
import clinical.utils.FileUtils;
import clinical.web.CBFBIRNConstants;

/**
 * Stands for real field map processing which takes hours for in-the-loop
 * testing of CBF workflow.
 * 
 * @author I. Burak Ozyurt
 * @version $Id: FieldMapProcessingStub.java 504 2011-12-30 00:44:02Z bozyurt $
 */
public class FieldMapProcessingStub {
	private CBFWFContext context;

	public FieldMapProcessingStub(CBFWFContext context) {
		this.context = context;
	}

	public void handleFieldMapProcessing(FieldMapInfo fmi, File matlabDir)
			throws Exception {
		Map<String, Map<String, AFNIBrik>> brikMap = new HashMap<String, Map<String, AFNIBrik>>(
				11);
		File cachedFMBriksDir = new File(System.getProperty("user.home"),
				"fmtest3_briks");
		File[] files = cachedFMBriksDir.listFiles();
		for (File f : files) {
			if (f.getName().endsWith(".BRIK") || f.getName().endsWith(".HEAD")) {
				String prefix = f.getName();
				prefix = prefix.replaceFirst("\\.\\w+$", "");
				prefix = prefix.replaceFirst("brik(\\+dbl)?\\+orig", "");
				Map<String, AFNIBrik> abList = brikMap.get(prefix);
				if (abList == null) {
					abList = new HashMap<String, AFNIBrik>(3);
					brikMap.put(prefix, abList);
				}
				String brikPrefix = f.getName().replaceFirst("\\.\\w+$", "");
				AFNIBrik ab = abList.get(brikPrefix);
				if (ab == null) {
					ab = new AFNIBrik();
					abList.put(brikPrefix, ab);
				}
				if (f.getName().endsWith(".BRIK")) {
					ab.brikFile = f;
				} else {
					ab.headFile = f;
				}
			}
		}

		Map<String, AFNIBrik> map = brikMap.get(fmi.getPrefix());
		if (map == null) {
			throw new Exception("No cached Fieldmap corrected data for "
					+ fmi.getPrefix());
		}

		File afniDIR = new File(this.context.getCacheDir(), CBFBIRNConstants.AFNI_DIR_NAME);
		AFNIBrik fmBrik = map.get(fmi.getPrefix() + "brik+dbl+orig");
		prepFMFile(fmBrik.headFile, fmi, afniDIR, true);
		prepFMFile(fmBrik.brikFile, fmi, afniDIR, true);
		
		AFNIBrik brik = map.get(fmi.getPrefix() + "brik+orig");
		prepFMFile(brik.headFile, fmi, afniDIR, false);
		prepFMFile(brik.brikFile, fmi, afniDIR, false);
	}

	void prepFMFile(File srcFile, FieldMapInfo fmi, File afniDIR,
			boolean fmCorrected) throws IOException {
		File afniFile = new File(afniDIR, srcFile.getName());
		FileUtils.copyFile(srcFile.getAbsolutePath(), afniFile
				.getAbsolutePath());
		Assertion.assertTrue(afniFile.exists() && afniFile.length() > 0);
		if (fmCorrected) {
			fmi.addFmOutBrikFile(afniFile);
		} else {
			fmi.addOutBrikFile(afniFile);
		}

	}

	public static class AFNIBrik {
		File brikFile;
		File headFile;

		public AFNIBrik() {
		}

	}
}
