package clinical.web.workflow.cbf;

import java.io.File;
import java.io.Serializable;
import java.text.ParseException;

import org.json.JSONException;
import org.json.JSONObject;

import clinical.web.vo.upload.SegmentInfo;
import clinical.web.workflow.common.JSONUtils;

public class SiemensFieldMapInfo implements Serializable {
	private static final long serialVersionUID = 1L;
	/** The source CBF nifti file to apply the fieldmap correction */
	private File srcNiftiFile;
	File b0MagDicomDir;
	File b0PhaseDicomDir;
	String prefix;
	File outputDir;
	SegmentInfo srcSI;
	AFNIBrik fmOutBrik;

	public SiemensFieldMapInfo(File srcNiftiFile, File b0MagDicomDir,
			File b0PhaseDicomDir, String prefix, File outputDir,
			SegmentInfo srcSI) {
		super();
		this.srcNiftiFile = srcNiftiFile;
		this.b0MagDicomDir = b0MagDicomDir;
		this.b0PhaseDicomDir = b0PhaseDicomDir;
		this.prefix = prefix;
		this.outputDir = outputDir;
		this.srcSI = srcSI;
	}

	public JSONObject toJSON() throws JSONException {
		JSONObject js = new JSONObject();
		JSONUtils.addJSONField("srcNiftiFile", getSrcNiftiFile(), js);
		JSONUtils.addJSONField("b0MagDicomDir", b0MagDicomDir, js);
		JSONUtils.addJSONField("b0PhaseDicomDir", b0PhaseDicomDir, js);
		if (prefix != null) {
			js.put("prefix", prefix);
		}
		JSONUtils.addJSONField("outputDir", outputDir, js);
		JSONUtils.addJSONSI("srcSI", srcSI, js);
		JSONUtils.addJSONAFNIBrik("fmOutBrik", fmOutBrik, js);
		return js;
	}

	public static SiemensFieldMapInfo initializeFromJSON(JSONObject js)
			throws JSONException, ParseException {
		File srcNiftiFile = JSONUtils.getFile("srcNiftiFile", js);
		File b0MagDicomDir = JSONUtils.getFile("b0MagDicomDir", js);
		File b0PhaseDicomDir = JSONUtils.getFile("b0PhaseDicomDir", js);
		File outputDir = JSONUtils.getFile("outputDir", js);
		String prefix = null;
		if (js.has("prefix")) {
			prefix = js.getString("prefix");
		}
		SegmentInfo srcSI = JSONUtils.getSI("srcSI", js);
		SiemensFieldMapInfo fmi = new SiemensFieldMapInfo(srcNiftiFile,
				b0MagDicomDir, b0PhaseDicomDir, prefix, outputDir, srcSI);
		fmi.fmOutBrik = JSONUtils.getAFNIBrik("fmOutBrik", js);
		return fmi;
	}

	public AFNIBrik getFmOutBrik() {
		return fmOutBrik;
	}

	public void setFmOutBrik(AFNIBrik fmOutBrik) {
		this.fmOutBrik = fmOutBrik;
	}

	public File getB0MagDicomDir() {
		return b0MagDicomDir;
	}

	public File getB0PhaseDicomDir() {
		return b0PhaseDicomDir;
	}

	public String getPrefix() {
		return prefix;
	}

	public File getOutputDir() {
		return outputDir;
	}

	public SegmentInfo getSrcSI() {
		return srcSI;
	}

	public File getSrcNiftiFile() {
		return srcNiftiFile;
	}
}
