package clinical.web.workflow.cbf;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import org.json.JSONException;
import org.json.JSONObject;

import clinical.web.workflow.common.JSONUtils;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: SingleFileInfo.java 366 2011-05-05 20:06:27Z bozyurt $
 */

public class SingleFileInfo implements IFileInfo {
	private File file;
	private String basename;
	private List<File> files = new ArrayList<File>(1);

	public SingleFileInfo(File aFile) {
		this.file = aFile;
		this.files.add(this.file);
		this.basename = this.file.getName().replaceFirst("\\.\\w+$", "");
	}

	@Override
	public String getBasename() {
		return this.basename;
	}

	@Override
	public List<File> getFiles() {
		return this.files;
	}

	@Override
	public String getType() {
		return "file";
	}

	@Override
	public JSONObject toJSON() throws JSONException {
		JSONObject js = new JSONObject();
		JSONUtils.addJSONField("path", file, js);
		return js;
	}

	public static SingleFileInfo initializeFromJSON(JSONObject js)
			throws JSONException {
		String path = js.getString("path");
		File f = new File(path);
		return new SingleFileInfo(f);
	}

}
