package clinical.web.workflow.cbf.group;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import clinical.web.common.vo.Factor;
import clinical.web.vo.GroupAnalysisCBFJobInfo;
import clinical.web.workflow.common.JSONUtils;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id$
 */
public class GroupAnalysisContext implements Serializable {
	private static final long serialVersionUID = 1L;
	private String dbID;
	private String cacheDir;
	private String matlabDir;
	private String templateDir;
	private String emailTo;
	private String filterQueryString;
	private String jobID;
	private List<GroupAnalysisCBFJobInfo> jiList;
	private List<Factor> selectedFactors;
	private boolean repeatedMeasures = false;
	private final String gaName;
	private final String afniActivationMapScript;
	private boolean doQWarp = false;

	public GroupAnalysisContext(String dbID, String cacheDir,
			String filterQueryString, String jobID,
			List<GroupAnalysisCBFJobInfo> jiList, List<Factor> factors,
			boolean repeatedMeasures, String gaName,
			String afniActivationMapScript, boolean doQWarp) {
		super();
		this.dbID = dbID;
		this.cacheDir = cacheDir;
		this.filterQueryString = filterQueryString;
		this.jobID = jobID;
		this.jiList = jiList;
		this.selectedFactors = factors;
		this.repeatedMeasures = repeatedMeasures;
		this.gaName = gaName;
		this.afniActivationMapScript = afniActivationMapScript;
		this.doQWarp = doQWarp;
	}

	public String getDbID() {
		return dbID;
	}

	public String getCacheDir() {
		return cacheDir;
	}

	public String getMatlabDir() {
		return matlabDir;
	}

	public String getTemplateDir() {
		return templateDir;
	}

	public String getEmailTo() {
		return emailTo;
	}

	public String getFilterQueryString() {
		return filterQueryString;
	}

	public String getJobID() {
		return jobID;
	}

	public List<GroupAnalysisCBFJobInfo> getJiList() {
		return jiList;
	}

	public JSONObject toJSON() throws JSONException {
		JSONObject js = new JSONObject();
		js.put("dbID", dbID);
		js.put("cacheDir", cacheDir);
		js.put("jobID", jobID);
		JSONArray jsArr = new JSONArray();
		js.put("jiList", jsArr);
		for (GroupAnalysisCBFJobInfo ji : jiList) {
			jsArr.put(ji.toJSON());
		}

		if (templateDir != null) {
			js.put("templateDir", templateDir);
		}
		if (matlabDir != null) {
			js.put("matlabDir", matlabDir);
		}
		if (emailTo != null) {
			js.put("emailTo", emailTo);
		}

		JSONArray factorArr = new JSONArray();
		js.put("factors", factorArr);
		for (Factor factor : selectedFactors) {
			factorArr.put(factor.toJSON());
		}
		js.put("repeatedMeasures", repeatedMeasures);
		JSONUtils.addStringField(js, "gaName", this.gaName, "");
		JSONUtils.addStringField(js, "afniActivationMapScript",
				afniActivationMapScript, "");
		js.put("doQWarp", doQWarp);
		return js;
	}

	public static GroupAnalysisContext fromJSON(JSONObject js)
			throws JSONException {
		String dbID = js.getString("dbID");
		String cacheDir = js.getString("cacheDir");
		String jobID = js.getString("jobID");

		JSONArray jsArr = js.getJSONArray("jiList");
		List<GroupAnalysisCBFJobInfo> jiList = new ArrayList<GroupAnalysisCBFJobInfo>(
				jsArr.length());
		for (int i = 0; i < jsArr.length(); i++) {
			jiList.add(GroupAnalysisCBFJobInfo.fromJSON(jsArr.getJSONObject(i)));
		}

		String filterQueryString = null;
		if (js.has("filterQueryString")) {
			filterQueryString = js.getString("filterQueryString");
		}

		boolean repeatedMeasures = (js.has("repeatedMeasures")) ? js
				.getBoolean("repeatedMeasures") : false;

		List<Factor> factorList = null;

		if (js.has("factors")) {
			jsArr = js.getJSONArray("factors");
			factorList = new ArrayList<Factor>(jsArr.length());
			for (int i = 0; i < jsArr.length(); i++) {
				factorList.add(Factor.fromJSON(jsArr.getJSONObject(i)));
			}
		} else {
			factorList = new ArrayList<Factor>(0);
		}
		String gaName = null;
		if (js.has("gaName")) {
			gaName = js.getString("gaName");
		}
		String afniActivationMapScript = js.has("afniActivationMapScript") ? js
				.getString("afniActivationMapScript") : null;

		boolean doQWarp = false;
		if (js.has("doQWarp")) {
			doQWarp = js.getBoolean("doQWarp");
		}

		GroupAnalysisContext ctx = new GroupAnalysisContext(dbID, cacheDir,
				filterQueryString, jobID, jiList, factorList, repeatedMeasures,
				gaName, afniActivationMapScript, doQWarp);

		if (js.has("templateDir")) {
			ctx.templateDir = js.getString("templateDir");
		}
		if (js.has("matlabDir")) {
			ctx.matlabDir = js.getString("matlabDir");
		}
		if (js.has("emailTo")) {
			ctx.emailTo = js.getString("emailTo");
		}

		return ctx;
	}

	public void setMatlabDir(String matlabDir) {
		this.matlabDir = matlabDir;
	}

	public void setTemplateDir(String templateDir) {
		this.templateDir = templateDir;
	}

	public void setEmailTo(String emailTo) {
		this.emailTo = emailTo;
	}

	public List<Factor> getSelectedFactors() {
		return selectedFactors;
	}

	public boolean isRepeatedMeasures() {
		return repeatedMeasures;
	}

	public String getGaName() {
		return gaName;
	}

	public String getAfniActivationMapScript() {
		return afniActivationMapScript;
	}

	public boolean isDoQWarp() {
		return doQWarp;
	}

}
