package clinical.web.workflow.cbf.group;

import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import clinical.web.common.vo.Factor;
import clinical.web.vo.CBFROIJobAssociation;
import clinical.web.workflow.common.JSONUtils;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id$
 */
public class GroupROIAnalysisContext implements Serializable {
	private static final long serialVersionUID = 1L;
	private final String dbID;
	private final String cacheDir;
	private String matlabDir;
	private String templateDir;
	private String emailTo;
	private final List<CBFROIJobAssociation> assocList;
	private final String filterQueryString;
	private final String jobID;
	private final List<Factor> selectedFactors;
	private final boolean repeatedMeasures;
	private final String gaName;

	public GroupROIAnalysisContext(String dbID, String cacheDir,
			List<CBFROIJobAssociation> assocList, String filterQueryString,
			String jobID, List<Factor> factors, boolean repeatedMeasures,
			String gaName) {
		super();
		this.dbID = dbID;
		this.assocList = assocList;
		this.cacheDir = cacheDir;
		this.filterQueryString = filterQueryString;
		this.jobID = jobID;
		this.selectedFactors = factors;
		this.repeatedMeasures = repeatedMeasures;
		this.gaName = gaName;
	}

	public String getDbID() {
		return dbID;
	}

	public String getCacheDir() {
		return cacheDir;
	}

	public String getMatlabDir() {
		return matlabDir;
	}

	public String getTemplateDir() {
		return templateDir;
	}

	public String getEmailTo() {
		return emailTo;
	}

	public String getFilterQueryString() {
		return filterQueryString;
	}

	public JSONObject toJSON() throws JSONException {
		JSONObject js = new JSONObject();
		js.put("dbID", dbID);
		js.put("cacheDir", cacheDir);
		js.put("jobID", jobID);
		JSONArray jsArr = new JSONArray();
		js.put("assocList", jsArr);
		for (CBFROIJobAssociation assoc : assocList) {
			jsArr.put(assoc.toJSON());
		}

		if (templateDir != null) {
			js.put("templateDir", templateDir);
		}
		if (matlabDir != null) {
			js.put("matlabDir", matlabDir);
		}
		if (emailTo != null) {
			js.put("emailTo", emailTo);
		}
		if (filterQueryString != null) {
			js.put("filterQueryString", filterQueryString);
		}
		JSONArray factorArr = new JSONArray();
		js.put("factors", factorArr);
		for (Factor factor : selectedFactors) {
			factorArr.put(factor.toJSON());
		}
		js.put("repeatedMeasures", repeatedMeasures);

		JSONUtils.addStringField(js, "gaName", this.gaName, "");
		return js;
	}

	public static GroupROIAnalysisContext fromJSON(JSONObject js)
			throws JSONException, ParseException {
		String dbID = js.getString("dbID");
		String cacheDir = js.getString("cacheDir");
		String jobID = js.getString("jobID");

		JSONArray jsArr = js.getJSONArray("assocList");
		List<CBFROIJobAssociation> assocList = new ArrayList<CBFROIJobAssociation>(
				jsArr.length());
		for (int i = 0; i < jsArr.length(); i++) {
			assocList
					.add(CBFROIJobAssociation.fromJSON(jsArr.getJSONObject(i)));
		}

		String filterQueryString = null;
		if (js.has("filterQueryString")) {
			filterQueryString = js.getString("filterQueryString");
		}

		boolean repeatedMeasures = (js.has("repeatedMeasures")) && js
                .getBoolean("repeatedMeasures");

		List<Factor> factorList;

		if (js.has("factors")) {
			jsArr = js.getJSONArray("factors");
			factorList = new ArrayList<Factor>(jsArr.length());
			for (int i = 0; i < jsArr.length(); i++) {
				factorList.add(Factor.fromJSON(jsArr.getJSONObject(i)));
			}
		} else {
			factorList = new ArrayList<Factor>(0);
		}
		String gaName = null;
		if (js.has("gaName")) {
			gaName = js.getString("gaName");
		}

		GroupROIAnalysisContext ctx = new GroupROIAnalysisContext(dbID,
				cacheDir, assocList, filterQueryString, jobID, factorList,
				repeatedMeasures, gaName);

		if (js.has("templateDir")) {
			ctx.templateDir = js.getString("templateDir");
		}
		if (js.has("matlabDir")) {
			ctx.matlabDir = js.getString("matlabDir");
		}
		if (js.has("emailTo")) {
			ctx.emailTo = js.getString("emailTo");
		}
		return ctx;
	}

	public void setMatlabDir(String matlabDir) {
		this.matlabDir = matlabDir;
	}

	public void setTemplateDir(String templateDir) {
		this.templateDir = templateDir;
	}

	public void setEmailTo(String emailTo) {
		this.emailTo = emailTo;
	}

	public List<CBFROIJobAssociation> getAssocList() {
		return assocList;
	}

	public String getJobID() {
		return jobID;
	}

	public List<Factor> getSelectedFactors() {
		return selectedFactors;
	}

	public boolean isRepeatedMeasures() {
		return repeatedMeasures;
	}

	public String getGaName() {
		return gaName;
	}

}
