package clinical.web.workflow.common;

import java.io.File;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import clinical.web.vo.upload.SegmentInfo;
import clinical.web.workflow.cbf.AFNIBrik;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: JSONUtils.java 602 2012-05-09 23:43:01Z bozyurt $
 */
public class JSONUtils {

	public static List<File> getFiles(String fieldName, JSONObject js)
			throws JSONException {
		List<File> files = new ArrayList<File>(2);
		if (js.has(fieldName)) {
			JSONArray arr = js.getJSONArray(fieldName);
			for (int i = 0; i < arr.length(); i++) {
				String s = arr.getString(i);
				files.add(new File(s));
			}
		}
		return files;
	}

	public static File getFile(String fieldName, JSONObject js)
			throws JSONException {
		if (js.has(fieldName)) {
			String value = js.getString(fieldName);
			return new File(value);
		}
		return null;
	}

	public static SegmentInfo getSI(String fieldName, JSONObject js)
			throws JSONException, ParseException {
		if (js.has(fieldName)) {
			return SegmentInfo.initializeFromJSON(js.getJSONObject(fieldName));
		}
		return null;
	}

	public static AFNIBrik getAFNIBrik(String fieldName, JSONObject js)
			throws JSONException, ParseException {
		if (js.has(fieldName)) {
			return AFNIBrik.initializeFromJSON(js.getJSONObject(fieldName));
		}
		return null;
	}

	public static void addJSONField(String fieldName, File value, JSONObject js)
			throws JSONException {
		if (value != null) {
			js.put(fieldName, value.getAbsolutePath());
		}
	}

	public static void addJSONSI(String fieldName, SegmentInfo si, JSONObject js)
			throws JSONException {
		if (si != null) {
			js.put(fieldName, si.toJSON());
		}
	}

	public static void addJSONAFNIBrik(String fieldName, AFNIBrik brik,
			JSONObject js) throws JSONException {
		if (brik != null) {
			js.put(fieldName, brik.toJSON());
		}

	}

	public static void addJSONArray(String fieldName, List<File> files,
			JSONObject js) throws JSONException {
		if (files != null) {
			JSONArray arr = new JSONArray();
			for (File f : files) {
				arr.put(f.getAbsolutePath());
			}
			js.put(fieldName, arr);
		}
	}

	public static void addStringField(JSONObject js, String name, String value,
			String defaultVal) throws JSONException {
		if (value != null) {
			js.put(name, value);
		} else {
			js.put(name, defaultVal);
		}
	}

	public static String getString(JSONObject js, String name)
			throws JSONException {
		if (js.has(name)) {
			return js.getString(name);
		}
		return null;
	}

}
