package clinical.xml;

import java.io.*;
import java.text.SimpleDateFormat;
import java.util.Date;

import javax.xml.datatype.XMLGregorianCalendar;

import org.jdom.*;
import org.jdom.input.*;
import org.jdom.output.*;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: XMLUtils.java 91 2009-08-17 23:38:26Z bozyurt $
 */
public class XMLUtils {
	SimpleDateFormat tsFormat = new SimpleDateFormat("");
	private XMLUtils() {
	}

	public static void prettyPrint(String xmlDoc) throws IOException,
			JDOMException {
		prettyPrint(xmlDoc, new OutputStreamWriter(System.out));
	}

	public static void prettyPrint(String xmlDoc, Writer out)
			throws IOException, JDOMException {
		SAXBuilder builder = new SAXBuilder();
		StringReader reader = new StringReader(xmlDoc);
		Document doc = builder.build(reader);
		XMLOutputter xout = new XMLOutputter(Format.getPrettyFormat());
		xout.output(doc.getRootElement(), out);
	}

	public static Date toDate(XMLGregorianCalendar cal) {
        return cal.toGregorianCalendar().getTime();
	}

}
