package clinical.xml.export;

import javax.jws.WebService;

import clinical.web.IAppConfigService;
import clinical.web.ISQLDialect;
import clinical.web.ServiceFactory;
import clinical.web.common.UserInfo;
import clinical.web.services.AppConfigService;
import clinical.xml.ApplicationUtils;

/**
 * @author I. Burak Ozyurt
 * @version $Id: XCEDE2ServiceImpl.java 69 2009-06-04 20:24:43Z bozyurt $
 */

@WebService(endpointInterface = "clinical.xml.export.XCEDE2Service", serviceName = "XCEDE2Service", portName = "xcede2Port")
public class XCEDE2ServiceImpl implements XCEDE2Service {

	public String exportAssessmentDataForSubject(String webUser, String pwd,
			String subjectID, int expID) throws XCEDEFault {
		XCEDE2SeriesExporter se = null;
		String dbID = null;
		try {
			dbID = getDBID();
			UserInfo ui = ApplicationUtils.authenticate(webUser, pwd, dbID);

			ISQLDialect sqlDialect = ServiceFactory.getSQLDialect(dbID);
			se = new XCEDE2SeriesExporter(dbID, sqlDialect);
			String result = se
					.exportAssessmentDataForSubject(ui, subjectID, expID);
			return result;
		} catch (Throwable t) {
			t.printStackTrace();
			throw new XCEDEFault(ApplicationUtils.prepareErrorMessage(t));
		}
	}

	public int importAssessmentDataForSubject(String webUser, String pwd,
			String xcedeAssessment, String protocolID, int protocolVersion)
			throws XCEDEFault {
		XCEDE2SeriesExporter se = null;
		String dbID = null;
		try {
			dbID = getDBID();
			System.out.println("dbID:" + dbID);
			ISQLDialect sqlDialect = ServiceFactory.getSQLDialect(dbID);
			se = new XCEDE2SeriesExporter(dbID, sqlDialect);
			UserInfo ui = ApplicationUtils.authenticate(webUser, pwd, dbID);
			System.out.println("XCEDE\n------------");
			System.out.println(xcedeAssessment);
			System.out.println("XCEDE\n------------");
			
			se.importAssessmentDataFromXCEDE(ui, dbID, xcedeAssessment,
					protocolID, protocolVersion);

			return 0;
		} catch (Throwable t) {
			t.printStackTrace();
			throw new XCEDEFault(ApplicationUtils.prepareErrorMessage(t));
		}
	}

	protected String getDBID() throws Exception {
		IAppConfigService cs = AppConfigService.getInstance();
		String dbID = cs.getParamValue("fbirn.dbid");

		if (dbID == null || dbID.trim().length() == 0) {
			throw new Exception(
					"Cannot detect data source! Possible misconfiguration! dbID:" + dbID);
		}
		return dbID;
	}

	public int[] getAllExperimentIDs(String webUser, String pwd)
			throws XCEDEFault {
		XCEDE2SeriesExporter se = null;
		String dbID = null;
		try {
			dbID = getDBID();
			UserInfo ui = ApplicationUtils.authenticate(webUser, pwd, dbID);
			ISQLDialect sqlDialect = ServiceFactory.getSQLDialect(dbID);
			se = new XCEDE2SeriesExporter(dbID, sqlDialect);
			return se.getAllExperimentIDs(ui);
		} catch (Throwable t) {
			t.printStackTrace();
			throw new XCEDEFault(ApplicationUtils.prepareErrorMessage(t));
		}
	}

	public String[] getAllSubjects(String webUser, String pwd, int expID)
			throws XCEDEFault {
		XCEDE2SeriesExporter se = null;
		String dbID = null;
		try {
			dbID = getDBID();
			UserInfo ui = ApplicationUtils.authenticate(webUser, pwd, dbID);
			ISQLDialect sqlDialect = ServiceFactory.getSQLDialect(dbID);
			se = new XCEDE2SeriesExporter(dbID, sqlDialect);
			return se.getAllSubjectsForExperiment(ui, expID);
		} catch (Throwable t) {
			t.printStackTrace();
			throw new XCEDEFault(ApplicationUtils.prepareErrorMessage(t));
		}
	}

	public String[] getExperimentNames(String webUser, String pwd, int[] expIDs)
			throws XCEDEFault {
		XCEDE2SeriesExporter se = null;
		String dbID = null;
		try {
			dbID = getDBID();
			UserInfo ui = ApplicationUtils.authenticate(webUser, pwd, dbID);
			ISQLDialect sqlDialect = ServiceFactory.getSQLDialect(dbID);
			se = new XCEDE2SeriesExporter(dbID, sqlDialect);
			return se.getExperimentNames(ui, expIDs);
		} catch (Throwable t) {
			t.printStackTrace();
			throw new XCEDEFault(ApplicationUtils.prepareErrorMessage(t));
		}
	}

}
