package clinical.xml.export;

import javax.xml.ws.WebFault;

@WebFault(name = "faultDetail", targetNamespace = "http://export.xml.clinical/")
public class XCEDEFault extends Exception {
   public static final long serialVersionUID = 20080613134533L;

   private FaultDetail faultDetail;

   public XCEDEFault() {
      super();
   }

   public XCEDEFault(String message) {
      super(message);
   }

   public XCEDEFault(String message, Throwable cause) {
      super(message, cause);
   }

   public XCEDEFault(String message, FaultDetail faultDetail) {
      super(message);
      this.faultDetail = faultDetail;
   }

   public XCEDEFault(String message, FaultDetail faultDetail, Throwable cause) {
      super(message, cause);
      this.faultDetail = faultDetail;
   }

   public FaultDetail getFaultInfo() {
      return this.faultDetail;
   }
}
