<%@ page contentType="text/html;charset=UTF-8" language="java" %>
<%@ taglib uri="/WEB-INF/struts-bean.tld" prefix="bean" %>
<%@ taglib uri="/WEB-INF/struts-html.tld" prefix="html" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jstl/core" %>

<style>
.acb {
  margin-bottom:0.5em;
}

#autoCompleteMenu ul {
  width: 30em;
}

</style>
<script type="text/javascript">
  var helpSystem = null;
  window.addOnLoadListener(onLoadHandler);
  
  function onLoadHandler() {
    var options = [];
    var url = '<html:rewrite page="/help.do?context=as_query"/>';
    helpSystem = new bal.AjaxHelpSystem(url, options);
    handleAssessmentQPanelPopulation();
  }

  
  var asiList = <c:out value="${asSelectForm.queryInfo.aqi.JSONStr}" escapeXml="false" />;
  var scoreNames = null;
  
  function handleAssessmentQPanelPopulation() {
     var asSelector = $('assessmentSel');
     if (!asSelector) return;
	  var asiSelIdx = 0;
     if (asSelector.options.length == 0) {
	     for(var i = 0; i < asiList.length; i++) {
		     var asi = asiList[i];
			  var option = new Option(asi.name, asi.asId);
			  if (i == 0) {
				  option.selected = true;
				  asiSelIdx = i;
			  }
			  try {
				  asSelector.add(option,null);
			  } catch(e) {
				  asSelector.add(option,-1);
			  }
	     }
     }
	  prepScorePanel(asiSelIdx, 'scp');
	  handleLoadedQuery();
  }
  
  function handleAssessmentChange() {
	  var asiSelector = $('assessmentSel');
	  if (!asiSelector) return;
	  prepScorePanel(asiSelector.selectedIndex, 'scp');
  }
  
  function prepScorePanel(asiSelIdx, divId) {
		var scores = asiList[asiSelIdx].scores;
		scoreNames = new Array();
		for(var i = 0; i < scores.length; i++) {
			scoreNames[i] = scores[i].name;
		}
		new Autocompleter.Local('scoreField', 'autoCompleteMenu', 
            scoreNames, {choices : 20} );	
  }
  
  function setScoreField(value) {
     var scoreField = $('scoreField');
     if ( scoreField) {
        scoreField.value = value;
        var div = $('scp');
        if (div && div.popupViewer)
             div.popupViewer.hide();
     }
     return false;
  }
  
  function showAllScores(evt, elem) {
	  if (!elem) return false;
	  if (!scoreNames) return false;
     var mx = 0, my = 0;
     if (!evt) 
       evt = window.event;
     if (evt.pageX || evt.pageY)      {
       mx = evt.pageX;
       my = evt.pageY;
     } else if (evt.clientX || evt.clientY)   {
       mx = evt.clientX + document.body.scrollLeft
         + document.documentElement.scrollLeft;
       my = evt.clientY + document.body.scrollTop
         + document.documentElement.scrollTop;
     }
	  var content = "<table border='0' cellspacing='0' cellpadding='2'>";
     var noCols = 2;
     var noRows = Math.floor(scoreNames.length / noCols);
     if ( (scoreNames.length % noCols) > 0) noRows++;
     for(var i = 0; i < noRows; i++) {
		  content += "\n<tr>";
		  for(var j = 0; j < noCols; j++) {
			  content += "<td>";
			  var idx = i * noCols + j;
			  if ( idx < scoreNames.length)  {
              content += "<a href='javascript:{}' class='selectionlink' onclick=\"return setScoreField('" + scoreNames[idx]
                        + "');\">" + scoreNames[idx] + "</a>";
              
			  } else 
				  content += "&nbsp;";
			  content += "</td>"
		  }	
		  content += "</tr>";
	  }
     bal.Popup.showPopup(mx, my, elem.parentNode, content);
     return false;
  }
  
  function handleLoadedQuery() {
	  var div = $('qbp');
	  for(var i = 0; i < asiList.length; i++) {
		  var asi = asiList[i];
		  if (asi.selected) {
			  var aqpId = asi.name.replace(/\s+/g,'_');
			  var asiQPartPanel = $(aqpId);
			  if (!asiQPartPanel) {
				  asiQPartPanel = utils.newDomNode('div', aqpId);
				  div.appendChild(asiQPartPanel);
				  new Insertion.Bottom(asiQPartPanel,
					  "<p><b>" + asi.name + "</b></p>");
			  }
			  for(var j=0; j < asi.scores.length; j++) {
				  if (asi.scores[j].selected) {
					  var score = asi.scores[j];
					  var useConnector = isConnectorRequired();
					  var ajaxResults = new Array();
	              var url = '<html:rewrite page="/caquery.do?actionParam=getScorecodes"/>';
					  var idPrefix = asi.asId + "__" + score.name.replace(/\s+/g,':');
					  
					  new Ajax.Request(url,  { method:"get", asynchronous: false, 
			          encoding: 'ISO-8859-1', evalJSON : false,
			          parameters: {asID: asi.asId, scoreName: score.name},
			          onSuccess: function(response) {
				       var ro = eval('(' + response.responseText + ')');					 
					      if (ro.hasEnums)  
								ajaxResults.push( ro );					 
						 }
					  });
					 
					  addQueryPart(asiQPartPanel, idPrefix, score.name, score.type, useConnector, 
						  ajaxResults, score.operator, score.rhs); 					  
				  }
			  }
		  }
	  }     
  }
  
  function handleAddQueryPart() {
	  var asiSelector = $('assessmentSel');
	  if (!asiSelector) return;
	  var scoreField = $('scoreField');
	  if (!scoreField || !scoreField.value) {
		  //TODO show validation message
		  return false;
	  }
	  var asi = asiList[ asiSelector.selectedIndex ];
	  var score = findScore(asi, scoreField.value);
	  if (!score) {
		  alert("Not a valid score:" + scoreField.value);
		  scoreField.value='';
		  return false;
	  }
	  var div = $('qbp');
	  var aqpId = asi.name.replace(/\s+/g,'_');
	  //alert('aqpId:' + aqpId);
	  var asiQPartPanel = $(aqpId);
	  if (!asiQPartPanel) {
		  asiQPartPanel = utils.newDomNode('div', aqpId);
		  div.appendChild(asiQPartPanel);
		  new Insertion.Bottom(asiQPartPanel,
			  "<p><b>" + asi.name + "</b></p>");
	  }
	  var useConnector = isConnectorRequired();
	  
	  var idPrefix = asi.asId + "__" + score.name.replace(/\s+/g,':');
	  var ajaxResults = new Array();
	  var url = '<html:rewrite page="/caquery.do?actionParam=getScorecodes"/>';
	  new Ajax.Request(url,  { method:"get", asynchronous: false, 
			  encoding: 'ISO-8859-1', evalJSON : false,
			  parameters: {asID: asi.asId, scoreName: score.name},
			  onSuccess: function(response) {
					 var ro = eval('(' + response.responseText + ')');					 
					 if (ro.hasEnums)  {
				      ajaxResults.push( ro );
					 }
			  },
			  onException: function(transport,e){
				  // no op
		     }			
		  });
	  addQueryPart(asiQPartPanel, idPrefix, score.name, score.type, useConnector, ajaxResults); 
	  
	  scoreField.value='';
	  return false;
  }
  
  function findScore(asi, scoreName) {
	  var list = asi.scores;
	  for(var i = 0; i < list.length; i++)
		  if (list[i].name == scoreName)
		     return list[i];
	  return null;
  }
  
  function isConnectorRequired() {
	  var div = $('qbp');
	  var els = div.getElementsByTagName('div');
	  if (!els) return false;
	  for(	var i = 0; i < els.length; i++) {
		  var scoreDivs = els[i].getElementsByTagName('div');
		  if ( scoreDivs && scoreDivs.length > 0) return true;		 
     }
	  return false;
  }
  
  
  function addQueryPart(container, idPrefix, colName, colType, useConnector, ajaxResults, opCode, rhsValue) {
     var divId = idPrefix + "__qp";
     if ( $(divId) ) {
       return;
     }
     var div = utils.newDomNode('div', divId);
     container.appendChild(div);
     if ( useConnector) {
        var rbDivId = idPrefix + "__connector";
        var rbDiv = utils.newDomNode('div',rbDivId);
        div.appendChild(rbDiv);
        var andButton = utils.newRadioBut(idPrefix + "__and",rbDivId, "AND","AND",true);
        var orButton = utils.newRadioBut(idPrefix + "__or",rbDivId, "OR","OR",false);
        rbDiv.appendChild(andButton);
        new Insertion.After(andButton,"&nbsp;");
        rbDiv.appendChild(orButton);        
     }
     new Insertion.Bottom(div,colName + " &nbsp;");
     if (colType != 'varchar') {
        var opts = [ {value:1, label:'='}, {value:2, label:'>'} ,
          {value:3, label:'<'}, {value:4, label:'<>'},
          {value:5, label:'>='}, {value:6, label:'<='}];
          var sel = utils.createSelect(idPrefix + "__operator", opts);          
          div.appendChild( sel );
			 if (ajaxResults && ajaxResults.length == 1) {
				 var enumOpts = [];
				 var enums = ajaxResults[0].sci;
				 enumOpts.push( {value: '*', label: '*'});
				 for(var i = 0; i < enums.length; i++) 
					 enumOpts.push( {value: enums[i].c, label : enums[i].l} );
				 var enumSel = utils.createSelect(idPrefix + "__enums", enumOpts);
				 new Insertion.Bottom(div, "&nbsp;");
				 div.appendChild( enumSel );
				  var html = "&nbsp;<input type='button' class='submit-button' name='Remove' value='Remove' "
				  + "onclick=\"return qb.removeQueryPart('"+ divId + "');\"></input>";
				  new Insertion.Bottom(div,html);
				  if (rhsValue) {					   
					   for(var i = 0; i < enumSel.options.length; i++) 
						   if (enumSel.options[i].value == rhsValue) enumSel.options[i].selected = true;
						   else enumSel.options[i].selected = false;
					  
				  }
			 } else {
     
				 new Insertion.Bottom(div, "&nbsp; <input type='text' id='" 
					 + idPrefix + "__rhs' size='8' value='*'></input>");
				 var html = "<br> <span style='margin-left:50px; line-height:1.5em;' >" 
				 + "Between <input type='text' id='" + idPrefix + "__lb' size='8' value=''>"
				 + " and "	 
				 +  "<input type='text' id='" + idPrefix + "__ub' size='8' value=''>&nbsp;"
				 +  "<input type='button' class='submit-button' name='Remove' value='Remove' onclick=\"return qb.removeQueryPart('"
				 + divId + "');\"></input>";
				 new Insertion.Bottom(div,html);
				 if (rhsValue) {
						$(idPrefix + "__rhs").value = rhsValue; 
				 }
			 }
			 if (opCode) {
				 for(var i = 0; i < sel.options.length; i++) 
					 if (sel.options[i].value == opCode) sel.options[i].selected = true;
					 else sel.options[i].selected = false;
			 }
     } else {
		  var opts = [ {value:1, label:'='}, {value:100, label:'starts with'} ,
          {value:101, label:'ends with'}, {value:102, label:'any of'}];
        var sel = utils.createSelect(idPrefix + "__operator", opts);          
		  div.appendChild( sel );
     
        new Insertion.Bottom(div, "&nbsp; <input type='text' id='" 
        	    + idPrefix + "__rhs' size='12' value='*'></input>&nbsp;"
				 + "<input type='button' class='submit-button' name='Remove' value='Remove' onclick=\"return qb.removeQueryPart('"
				 + divId + "');\"></input>");
     }
  }
  
  function buildQuery(verbose) {
     var asiSelector = $('assessmentSel');
     if ( !asiSelector) return;
     var div = $('qbp');
     var els = $A(div.getElementsByTagName('div'));
     if (!els) {
        alert("At least one criterion needs to be specified for querying!");
		  return false;
     }
     var aqJSON = "{asQPIList: [";
     var first = true;
     //var desc = "";
     //desc =els.inject(desc, function(s,value, idx) { 
     //  if (value && value.id) s += value.id + "\n"; return s; } );
     //alert("els:" + desc);
	  var count = 0;         
     for(var i = 0; i < els.length; i++) {
		   var asName = els[i].id.replace(/_/g,' ');
			var scoreDivs = els[i].getElementsByTagName('div');	
			for(var j = 0; j < scoreDivs.length; j++) {
				if (!scoreDivs[j] || !utils.strEndsWith(scoreDivs[j].id,"__qp")) continue;
				//alert("scoreDivs[" + j + "]:" + scoreDivs[j].id);
				var toks = scoreDivs[j].id.split('__');	
				if (!toks) continue;
				var asi = findAssessment(toks[0]);
				if(!asi) continue;
				var scoreName = toks[1].replace(/:/g,' ');
				var score = findScore(asi, scoreName);
				if(!score) continue;
	         var idPrefix = scoreDivs[j].id.replace(/__qp$/,'');                 
	         if (first) 
                first = false;
            else aqJSON += ", ";
				aqJSON += "{ asi: { name: '" + asi.name + "', asId:" + asi.asId + "},"
				+ "score:{ name: '" + score.name + "', type: '" + score.type + "'}, ";
				aqJSON += "connector: '";
				var andRB = $(idPrefix + "__and");
				if (andRB) {
					aqJSON += (andRB.checked) ? "AND'," : "OR',";
				} else {
					aqJSON += "NONE',";
				}
				//var selId = idPrefix + "__operator";
				//alert("selId:" + selId);
				var sel = $(idPrefix + "__operator");
				aqJSON += "operator: " + sel.options[sel.selectedIndex].value;
				var rhs = $(idPrefix + "__rhs");
				if (rhs && rhs.value) {
            	   var rhsVal = utils.trim(rhs.value);
						if ( rhsVal.length > 0) 
							aqJSON += ", rhs : '" + rhsVal + "'";		    
				} else {
					rhs = $(idPrefix + "__enums");
					if (rhs) 
						aqJSON += ", rhs : '" + rhs.options[rhs.selectedIndex].value + "'";
				}
				var lowBound = $(idPrefix + "__lb");
				if (lowBound && lowBound.value) {
					var val = utils.trim(lowBound.value);
					if ( val.length > 0)  
						aqJSON += ", lowBound: '" + val + "'";
				}		 
            var uppBound = $(idPrefix + "__ub");
				if (uppBound && uppBound.value) {
					var val = utils.trim(uppBound.value);
					if ( val.length > 0)  
						aqJSON += ", uppBound: '" + val + "'";
				}  
				aqJSON += "}\n";		
				count++;
			}// j
	  } //i
     aqJSON += "]}\n";
	  if (count == 0) {
		  alert("At least one score is necessary for querying clinical data!");
		  return null;			  
	  }
	  if(verbose) alert(aqJSON);
     return aqJSON;
  }
  
  function findAssessment(asId) {
	  for(var i = 0; i < asiList.length; i++) {
			if (asiList[i].asId == asId)
				return asiList[i];
	  }
	  return null;
  }
  
  function query(elem) {
		var json = buildQuery();
		if (!json) return false;
		elem.form.actionParam.value='query';
		elem.form.queryString.value=json;
      //alert("query:" + json);
		elem.form.submit();
		return false;
  }
  
  function msQuery(elem) {
     var json = buildQuery();
     if (!json) return false;
     elem.form.actionParam.value='msQuery';
     elem.form.queryString.value=json;
     //alert("msQuery:" + json);
     elem.form.submit();
     return false;   
  }
  
  function saveQuery(elem) {
	  var json = buildQuery();
	  if (!json) return false;
	  elem.form.actionParam.value='saveQuery';
	  elem.form.queryString.value=json;
	  elem.form.submit();
	  return false;	
  }
  
  function loadQuery(elem) {
     elem.form.actionParam.value='loadSavedQuery';
	  elem.form.submit();
	  return false;	 
  }
  
  function changeTab(form) {
     var div = $('qbp');
     var els = $A(div.getElementsByTagName('div'));
     if (els && els.length > 0) {
	  var json = buildQuery();
	  if (json) {
		  form.caQueryString.value = json;
	  }
     }
     form.submit();		
     return false;	   
  }
</script>
  
<div class="error">
<html:errors/>
</div>

<br>
<html:form action="/analysisresultquery" styleId="qtf">
  <input type="hidden" name="actionParam" value="Show"/>
  <input type="hidden" name="caQueryString" value=""/>         
</html:form>
<html:form action="/cbfreportquery" styleId="trf">
  <input type="hidden" name="actionParam" value="Show"/>
  <input type="hidden" name="caQueryString" value=""/>         
</html:form>
<div id="tabpanel">
   <ul id="tabs">      
        <li class="activelink"><a href="#" >Assessment</a></li>   
        <c:if test="${asSelectForm.supportAnalysisQuery}">
		   <li><a href='javascript:{}' onclick="changeTab($('qtf'));">Analysis</a></li>
         </c:if>
        <li><a href='javascript:{}' onclick="changeTab($('trf'));">Reports</a></li>
   </ul>
</div>
<html:form action="/caquery" styleId="cqForm">
<input type="hidden" name="actionParam" value=""/>
<input type="hidden" name="queryString" value=""/>

<div id="qb_wizard" >
   <div style="text-align:left; padding:0; margin:0; background-color:#ffcc33;  line-height:1.8em; ">
     <span class="mlarge" style="margin:5px;">Assessment Query Builder</span><br>
   </div>
   <c:if test="${not asSelectForm.supportAssessmentQuery}">
     <div>
        <span style="color:red; font-weight:bold; padding:5px;">No assessment metadata can be found. 
          Use CALM to add assessment metadata.</span>
     </div>
   </c:if>
   <div style="position:relative; padding-right:30em;">
      <span style="text-align:left;" > 
        <input type="button" class="submit-button" value="Save Query" onclick="return saveQuery(this);"></input>&nbsp;
      </span>
      <div style="text-align:right; position:absolute; right:0; top:0; width:30em; "> 
         <c:if test="${stateCoordinator.hasMultipleDatabases == true}">
              <input type="button" class="submit-button" onclick="return msQuery(this);" value="Multi-site Query"></input>&nbsp;
          </c:if>         
        <input type="button" class="submit-button" onclick="return query(this);" value="Query"></input>
      </div>     
      
   </div>
	<c:if test="${not empty asSelectForm.savedQuerySelector.savedQueries}" >
    <div style="text-align:left; padding-left:3px;">
       <span class="msmall">Saved Queries:</span>&nbsp;
	    <bean:define id="sqList" name="asSelectForm" property="savedQuerySelector.savedQueries"
                  type="java.util.Collection"/>

        <html:select name="asSelectForm" property="savedQuerySelector.selectedQueryID">
           <html:options collection="sqList" property="value"
                labelProperty="label"/>
        </html:select>
	     &nbsp;
	    <input type="button" value="Load Query" class="submit-button" onclick="return loadQuery(this);"></input>
       <br>
       <hr>  
    </div>
   </c:if>  
   <div style="margin:1em; line-height:1.6em; vertical-align:middle;">
	   <bean:define id="expIDList" name="asSelectForm" property="expSelector.experimentInfos"
          type="java.util.Collection"/>
		<div style="border: solid #00659c 2px; margin-bottom:5px; padding-bottom:3px; padding-top:3px;"> 	 
      <div style="padding-bottom:5px;">
        <span class="msmall" style="margin-left:5px;" >Experiment(s):</span>&nbsp;
        <html:select name="asSelectForm" property="expSelector.selectedExpID">
             <html:options collection="expIDList" property="value" labelProperty="label"/>
        </html:select>
      </div>
      <div>
       <bean:define id="qsList" name="asSelectForm" property="queryScopeSelector.queryScopeList"
            type="java.util.Collection"/>
       <span class="msmall" style="margin-left:5px;" >Query Matching Scope:</span>&nbsp;
       <html:select name="asSelectForm" property="queryScopeSelector.queryScope">
             <html:options collection="qsList" property="value" labelProperty="label"/>
       </html:select>
       <span id="help_21"> <button onclick="return helpHandler('help_21')">
          <img align="middle" class="help_button" src="<%=request.getContextPath()%>/pages/images/questionmark.png" width="19" height="19">
         </button>
       </span>  
      </div>
		</div>
      <span style="font-weight:bold;">Assessment:</span> &nbsp;<select id="assessmentSel" onchange="handleAssessmentChange()"> </select>
       &nbsp; 
      <div id="scp" style="border: solid #00659c 2px; padding: 5px; margin-top: 6px;">
	       <a href="#" onclick="return showAllScores(event,this);">Show All Scores</a>
          <p>Start typing to see matching scores for the selected assessment</p>
          <label>Score:</label>
          <input type="text" id="scoreField"></input>          
          &nbsp; <input type="button" class="submit-button" name="Add to Query" value="Add to Query" 
	     onclick="return handleAddQueryPart();"></input>
	  <div id="autoCompleteMenu"></div>
      </div>
      <div id="qbp" style="border: solid #00659c 2px; padding: 5px; margin-top: 6px;"></div>
   
    </div>
   
   <div style="text-align: right; ">
     <c:if test="${stateCoordinator.hasMultipleDatabases}">
     <input type="button" class="submit-button" onclick="return msQuery(this);" value="Multi-site Query"></input>&nbsp;            
     </c:if>
     <input type="button" class="submit-button" onclick="return query(this);" value="Query"></input>    
   </div>
   
</div>

</html:form>

<script>
     var divElem = $('qb_wizard');
     var options = {color: "#ffcc33", corners: 'top'};
     Rico.Corner.round( divElem, options );
     Rico.Corner.round( divElem,  {color: "#d3d3d3", corners: 'bottom'});
     var tabs = $$('#tabs li');
     tabs.each(
         function(el) { 
            Rico.Corner.round( el,  {color: "#00659c", corners: 'top'}); }
      );
     
</script>
