<%@ page contentType="text/html;charset=UTF-8" language="java" %>
<%@ taglib uri="/WEB-INF/struts-bean.tld" prefix="bean" %>
<%@ taglib uri="/WEB-INF/struts-html.tld" prefix="html" %>
<%@ taglib uri="/WEB-INF/struts-logic.tld" prefix="logic" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jstl/core" %>

<%-- 
<script type="text/javascript" src="http://yui.yahooapis.com/combo?2.8.1/build/yahoo-dom-event/yahoo-dom-event.js"></script>
<script src="http://yui.yahooapis.com/2.8.1/build/element/element-min.js"></script>
--%>

<script type="text/javascript" src="yui/yahoo-dom-event/yahoo-dom-event.js"></script>
<script type="text/javascript" src="yui/element/element-min.js"></script>
<script language='javascript' src='validator.js'></script>

<script language='javascript'>
  
  var exp2ViListMap = null;

  function onLoadHandler() {
	  exp2ViListMap = <c:out value="${dtiForm.exp2ViListJSON}" escapeXml="false" />;
	  handleViListPopulation();
  }

  function handleViListPopulation() {
	  var expSelector = document.getElementById('expSelector');
	  if (!expSelector) return;
	  var viSelector = document.getElementById('viSelector');
	  var selExpId = expSelector.options[ expSelector.selectedIndex].value; 
	  var vilInfo = exp2ViListMap[selExpId];
	  if (!vilInfo) return;
	  var viList = vilInfo.viList;
	  viSelector.options.length = 0;
	  for(var i = 0; i < viList.length; i++) {
		  var option = new Option( viList[i].label, viList[i].id);
		  try {
			  viSelector.add(option,null);
		  } catch(e) {
			  viSelector.add(option,-1);
		  }
	  }
  }

  function validate() {
	  var viSelector = document.getElementById('viSelector');
	  if (!viSelector) return false;
	  var count = 0;
	  for(var i = 0; i < viSelector.options.length; i++) {
		  if (viSelector.options[i].selected) {
			  count++;
		  }
	  }
	  if (count == 0) {
		  alert("At least a series needs to be selected for job submission!");
		  return false;
	  }
	  return true;
  }
	  
  function changeTab(form) {
	  form.submit();
	  return false;
  }
  
  YAHOO.util.Event.onDOMReady(function() {
     onLoadHandler();
  });

</script>

<div class="error">
    <html:errors/>
</div>

<html:form action="/cbfjobman" styleId="cjf">
   <input type="hidden" name="action" value="view" />
</html:form>
<div id="tabpanel">
   <ul id="tabs">  
       <li><a href='javascript:{}' onclick="changeTab($('cjf'))">ASL</a></li>
       <li class="activelink"><a href='#'>DTI</a></li>
   </ul>
</div>
<html:form action="/dtijobman" styleId="djf">
   <input type="hidden" name="action" value="submitJob" />

<div id="jobManPane" class="mainPanel">
  <div class="headerPane">
      <div class="mlarge" style="margin:0 0 0 5px; padding:0;">DTI Job Submission</div>
  </div>
<c:if test="${dtiForm.hasData == true}">
   
   <div class="input_div">
      <label><span class="label" title="Name of the project/experiment">Experiment:</span></label>
		<bean:define id="expList" name="dtiForm" property="expSelector.experimentInfos"
		    type="java.util.Collection"/>
	    <html:select styleId="expSelector" name="dtiForm"
		     property="expSelector.selectedExpID" onchange="handleViListPopulation();">
			 <html:options collection="expList" property="value" labelProperty="label" />
       </html:select>
	</div>
   <div class="input_div">
      <label><span class="label" title="Series for processing (Subject ID  Visit Date)">Series:</span></label>
		<select id="viSelector" name="viSelector">
		</select>
   </div>
   <div class="button_div">
	    <input type="submit" class="submit-button" value="Submit Job" id="viSelButton" onclick="return validate();"/>
	</div>
</c:if>
<c:if test="${not dtiForm.hasData}">
   <div class="input_div">
       <span style="color:red; font-weight:bold;"> No data is available for DTI processing! </span>
   </div>
</c:if>

</div>
</html:form>

<script>
     var divElem = $('jobManPane');
     var options = {color: "#ffcc33", corners: 'top'};
     Rico.Corner.round( divElem, options );
     Rico.Corner.round( divElem,  {color: "#d3d3d3", corners: 'bottom'});
     var tabs = $$('#tabs li');
     tabs.each(
         function(el) { 
            Rico.Corner.round( el,  {color: "#00659c", corners: 'top'}); }
      );
</script>

