// requires prototype >=1.5.1 and utils.js

var OverlayHandler = Class.create();

OverlayHandler.prototype = {
   initialize: function(hideExFun) {
      this.overlay = document.createElement("div");
      this.exHideFun = hideExFun;
      this.overlay.onclick = this.hide.bind(this);
      document.body.appendChild( this.overlay );
   },

   hide: function() {
      $(this.overlay).hide();
      this.exHideFun.call(this);
   },
   
   hideOverlay: function() {
	   $(this.overlay).hide();
	   // utils.hide(this.overlay);
   },

   show: function() {
      this.overlay.style.height = this.pageHeight() + "px";
      this.overlay.style.width = document.body.scrollWidth + "px";
      // alert("height:" + this.overlay.style.height );
      // utils.show(this.overlay); 
      $(this.overlay).show();
   },
   
   pageHeight: function() {
      if (document.viewport)
       return document.viewport.getDimensions().height;
      else 
	 return document.body.scrollHeight;
   }
};


var ImageSeriesViewer = Class.create();

ImageSeriesViewer.prototype = {
   initialize: function(retrievalUrl, onCloseHook) {
      this.retUrl = retrievalUrl;
      if (onCloseHook)
	     this.onCloseHook = onCloseHook;
      this.curIdx = -1;
      this.oh = new OverlayHandler(this.close.bind(this));
      if (this.oh)
         this.oh.show();
      new Ajax.Request(retrievalUrl, {
	   method: "get", asynchronous: false,
       encoding: 'ISO-8859-1', evalJSON : false,
	   onSuccess : this.onAjaxLoad.bind(this),
	   onException : this.onAjaxException.bind(this)
      });
       // $("isv_prev").onclick = this.prevImage.bind(this);
       // $("isv_next").onclick = this.nextImage.bind(this);
   },

   showImage: function() {
      var curImage = this.images[this.curIdx];
      var img = $("isv_image");
      if (img.firstChild ) {
	     img.removeChild( img.firstChild );
      }
      img.appendChild( curImage );
      var isv = $("isv");
      this._adjust(isv);
      // alert(isv.inspect() + " display:" + isv.style.display);
      utils.show(isv);
   },

   close: function() {
	   $("isv").hide();
   },
   
   closeWithOverlay: function() {
	   $("isv").hide();
	   if (this.oh) {
		   this.oh.hideOverlay();
		 // alert("closed overlay!");
	   };	   
	   return false;
   },

   prevImage: function() {
      --this.curIdx;
      $("isv_next").show();
      this.showImage();
      if (this.curIdx == 0) 
	 $("isv_prev").hide();
      return false;
   },

   nextImage : function() {
      ++this.curIdx;
      if ( this.curIdx >= (this.images.length -1)) 
	 $("isv_next").hide();
      this.showImage();
      $("isv_prev").show();
      
      return false;
   },

   _adjust: function(isv) {
      if (!isv) return;
      var w = isv.getWidth();
      var h = isv.getHeight();
      var t = utils.scrollY() +  utils.windowHeight() / 2 - h/2;
      if (t < 0) t = 0;
      var l = utils.scrollX() + utils.windowWidth() /2 - w/2;
      if (l < 0) l = 0;
      // alert("w:" + w + " h:" + h + " t:" + t + " l:" + l);
      isv.setStyle({ left : l + "px", top : t + "px"});
   },


   onAjaxLoad: function(transport) {
	   // alert(transport.responseText);
	   // alert("before eval");
	   var data = null;
	   try {
	     data = eval('(' + transport.responseText + ')');
	   } catch(e) {
		   alert("catched error:" + e);
	   }
	   var title = data.subjectID + " Visit:" + data.visit + " Seg:" + data.segment 
	      + " Site:" + data.siteID + " Experiment:" + data.experiment;
	   imgUrls = data.jpegs;
	   // alert("imgUrls:" + imgUrls.length);
	   this.images = new Array();
	   for(var i = 0; i < imgUrls.length; ++i) {
		   var img = new Image();
		   img.src = imgUrls[i];
		   this.images.push(img);
	   }

	   var isv = $("isv");
	   if (!isv) { 
		   isv = document.createElement("div"); 
		   isv.id = "isv"; 
		   isv.innerHTML =  '<div id="isv_title"><div id="isv_title_txt">' + title + '</div>' + 
		    '<a id="isv_close" href="#">Close</a>' + 
			'</div><div id="isv_image"></div>' +
		    '<div id="cc"> <span id="sliderElements"><div id="slider_track">' + 
		    ' <div id="slider_handle">&nbsp;</div></div></span>' +
		    '<span id="slider_value"></span>';
		   document.body.appendChild(isv);
		   $("isv_close").onclick = this.closeWithOverlay.bind(this);
	   }
	   var isvTitle = $("isv_title_txt");
	   // alert("title:" + title + "\nisvTitle:" + isvTitle);
	   if (isvTitle) {
	       isvTitle.innerHTML = title;
	   }

	   this.curIdx = 0;      
	   this.showImage();
	   this._createSlider(0, this.images.length -1);
   },

   onAjaxException: function(req, exc) {
	   // alert("req:" + req + "\nExc:" + exc);
   },

   _createSlider: function(minVal, maxVal) {
	   // alert("minVal:" + minVal + " maxVal:" + maxVal);
	   var values = [];
	   for(var i = minVal; i <= maxVal; i++) 
		   values.push(i);
	   new Control.Slider('slider_handle', "slider_track",
			   { range: $R(minVal, maxVal),
		   values : values,
		   sliderValue: minVal,
		   onChange: this._onSliceChange.bind(this),
		   onSlide: this._onSliceChange.bind(this) 
			   });
	   $('slider_value').innerHTML = minVal;
   },

   _onSliceChange: function(imageIdx) {
	   $('slider_value').innerHTML = imageIdx;
	   this.curIdx = imageIdx;      
	   this.showImage();
   },
};


