<%@ page contentType="text/html;charset=UTF-8" language="java" %>
<%@ taglib uri="/WEB-INF/struts-bean.tld" prefix="bean" %>
<%@ taglib uri="/WEB-INF/struts-html.tld" prefix="html" %>
<%@ taglib uri="/WEB-INF/struts-logic.tld" prefix="logic" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jstl/core" %>

<style>
  div .label {
    float: left;
    font-weight:bold;
    width: 12em;
    text-align: right;
    margin-right: 10px;
    clear: left;
}
  
</style>

<div class="error">
   <html:errors/>
</div>
<br>
<br>


 <html:form action="/rgman">
  <bean:define id="saved" name="expForm"
                 property="studyGroupInfo.saved" type="java.lang.Boolean"/>
<div id="sgmPane" class="mainPanel">
  <div class="headerPane">
     <c:if test="${expForm.studyGroupInfo.saved == false}">
        <div class="mlarge" style="margin:0 0 0 5px; padding:0;">New Study Group</div>
     </c:if>
     <c:if test="${expForm.studyGroupInfo.saved == true}">
        <div class="mlarge" style="margin:0 0 0 5px; padding:0;">Study Group (saved)</div>
     </c:if> 
  </div>
  <div class="input_div">
       <label><span class="label" title="Name of the project/experiment">Experiment:</span></label>
       <c:out value="${expForm.studyGroupInfo.experimentName}" />
  </div>
  <div class="input_div" style="display:none">
       <label><span class="label" title="Research Group Type for Experiment">Research Group Type:</span></label>
       <bean:define id="rgTypes" name="expForm"
                 property="studyGroupInfo.researchGroupTypeLVBeans" type="java.util.Collection"/>
       <html:select name="expForm" property="studyGroupInfo.researchGroupTypeID" 
                   disabled="<%= saved.booleanValue() %>">
                    <html:options collection="rgTypes" property="value" labelProperty="label"/>
       </html:select>
  </div>
  <div class="input_div">
       <label><span class="label" title="">Label:</span></label>
       <html:text name="expForm" property="studyGroupInfo.name" disabled="<%= saved.booleanValue() %>"/>
  </div>
  <div class="input_div">
       <label><span class="label" title="">Description:</span></label>
       <html:textarea name="expForm" property="studyGroupInfo.description" 
                   cols="40" rows="5"  disabled="<%= saved.booleanValue() %>" />
  </div>
  <c:if test="${expForm.studyGroupInfo.saved == false}">
    <div class="button_div">
      <html:submit  property="action" styleClass="submit-button"><bean:message key="button.add_studygroup"/></html:submit>
	</div>
  </c:if>	
	
<%-- 	
     <tr>
         <td>
          <bean:define id="saved" name="expForm"
                 property="studyGroupInfo.saved" type="java.lang.Boolean"/>

          <table border="0" cellspacing="0" width="100%">
           <tr>
             <td><b>Experiment:</b></td>
             <td><bean:write name="expForm" property="studyGroupInfo.experimentName"/></td>
           </tr>

            <tr>
             <td><b>Research Group Type:</b></td>
             <td>
               <bean:define id="rgTypes" name="expForm"
                 property="studyGroupInfo.researchGroupTypeLVBeans" type="java.util.Collection"/>
                 <html:select name="expForm" property="studyGroupInfo.researchGroupTypeID"
                    disabled="<%= saved.booleanValue() =%>">
                    <html:options collection="rgTypes" property="value" labelProperty="label"/>
                 </html:select>
             </td>
            </tr>
            <tr>
              <td><b>Name:</b></td>
              <td>
                 <html:text name="expForm" property="studyGroupInfo.name" disabled="<%= saved.booleanValue() %>"/>
              </td>
            </tr> 
            <tr>
             <td><b>Description:</b></td>
             <td><html:textarea name="expForm" property="studyGroupInfo.description" 
                   cols="40" rows="5"  disabled="<%= saved.booleanValue() %>" /></td>
             </tr> 
             <tr>
             <td colspan="2" align="right">
               <logic:equal  name="expForm" property="studyGroupInfo.saved" value="false"> 
                <html:submit  property="action" styleClass="submit-button"><bean:message key="button.add_studygroup"/></html:submit>&nbsp;
              </logic:equal>
            </td>
          </tr>
          </table>
         </td>
        </tr> 
    </table>
  </td>
 </tr>
</table>
--%>
</div>
</html:form>

<script>
     var divElem = jQuery('#sgmPane')[0];
     var options = {color: "#ffcc33", corners: 'top'};
     Rico.Corner.round( divElem, options );
     Rico.Corner.round( divElem,  {color: "#d3d3d3", corners: 'bottom'});
</script>
