<%@ page contentType="text/html;charset=UTF-8" language="java" %>

<%@ taglib prefix="c" uri="http://java.sun.com/jstl/core" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jstl/fmt" %>

<%@ taglib uri="/WEB-INF/struts-html.tld" prefix="html" %>
<%@ taglib uri="/WEB-INF/struts-bean.tld" prefix="bean" %>

<style>
 
#userView div .label {
    float: left;
    font-weight:bold;
    width: 20em;
    text-align: right;
    margin-right: 10px;
    clear: left;
}

</style>
<script type="text/javascript">
  function go1(elem,actionValue) {
      elem.form.action.value = actionValue;
      elem.form.submit();
      return false;
  } 
</script>
<div class="error">
  <html:errors/>
</div>

<form method="post" action="<c:url value="/userman.do"/>" >
  <input type="hidden" name="action" value=""></input>
  
  <div id="userView">
     <div class="divMainSectionTitle">
        User Configuration
     </div> 
     <div class="fieldbox" > 
          <div class="input_div">
            <span class="label">Web User Name:</span> 
            <c:if test="${umForm.opType == 'add'}">
              <html:text name="umForm" property="newUser.userName" size="10" maxlength="30" />
            </c:if> 
            <c:if test="${umForm.opType == 'edit'}">
              <html:text name="umForm" property="newUser.userName" size="10" maxlength="30" disabled="true"/>
            </c:if> 
          </div>
          <div class="input_div">
            <span class="label">Web User Password:</span> 
            <html:password name="umForm" property="newUser.password" size="10" maxlength="30" /> 
          </div>
          <div class="input_div">
            <span class="label">Web User Password (Confirm):</span> 
            <html:password name="umForm" property="newUser.passwordRepeat" size="10" maxlength="30" /> 
          </div>
          <div class="input_div">
            <span class="label">Web User Email:</span> 
            <html:text name="umForm" property="newUser.email" size="20" maxlength="60" /> 
          </div>
	  <div class="input_div">
            <bean:define id="dbUserList" name="umForm" property="newUser.dbUserSelector.dbUserList"
                   type="java.util.Collection"/>
	     <span class="label">Database User: </span>
	     <html:select name="umForm" property="newUser.dbUserSelector.selectedDBUserName">
	        <html:options collection="dbUserList" property="value" labelProperty="label" />
	     </html:select>
	  </div>
	  <div>
	      <c:if test="${umForm.opType == 'add'}">
            <input type="submit" class="submit-button" value="Add"	                  
	            onclick="return go1(this,'addUser')"></input>
	      </c:if>
	      <c:if test="${umForm.opType == 'edit'}">
            <input type="submit" class="submit-button" value="Save"	                  
	            onclick="return go1(this,'editUser')"></input>
	      </c:if>      
	  </div>
	</div>
   <%-- userView end --%>
  </div>

</form>

<script>
     var divElem = jQuery('#userView')[0];
     Rico.Corner.round( divElem,  {color: "#00659c", corners: 'top bottom'});
</script>
