<%@ page contentType="text/html;charset=UTF-8" language="java"%>

<%@ taglib prefix="c" uri="http://java.sun.com/jstl/core"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jstl/fmt"%>

<%@ taglib uri="/WEB-INF/struts-html.tld" prefix="html"%>
<%@ taglib uri="/WEB-INF/struts-bean.tld" prefix="bean"%>

<script type="text/javascript">
  var helpSystem = null;
  window.addOnLoadListener(onLoadHandler);
  
  function go1(elem,actionValue, webUser) {
      elem.form.action.value = actionValue;
      elem.form.curWebUser.value = webUser;
      elem.form.submit();
      return false;
  } 
  
  function viewAddEditWebUser(elem, webUser, opType) {
      elem.form.action.value = 'viewAddEditWebUser';
      elem.form.curWebUser.value = webUser;
      elem.form.opType.value = opType;
      elem.form.submit();
      return false;
  }

  function viewAddEditDbUser(elem, dbUser, opType) {
      elem.form.action.value = 'viewAddEditDbUser';
      elem.form.curDBUser.value = dbUser;
      elem.form.opType.value = opType;
      elem.form.submit();
      return false;
  }
  
  function removeWebUser(elem, webUser, dbUser) {
      elem.form.action.value = 'removeWebUser';
      elem.form.curWebUser.value = webUser;
      elem.form.curDBUser.value = dbUser;
      elem.form.submit();
      return false;
  }
 
 function go(elem,actionValue) {
      elem.form.action.value = actionValue;
      elem.form.submit();
      return false;    
 }
 
 function dbConfChanged(selectElem) {
     var selOption = selectElem.options[ selectElem.selectedIndex ];
     var form = selectElem.form;
     form.curDB.value = selOption.value;
     form.action.value = 'changeDB';
     form.submit();
     return false;
 }

 function onLoadHandler() {
    var options = [];
    var url = '<html:rewrite page="/help.do?context=db_admin"/>';
    helpSystem = new bal.AjaxHelpSystem(url, options);
 }

</script>

<div class="error"><html:errors /></div>

<form method="post" action="<c:url value="/udbconf.do"/>"><input
	type="hidden" name="action" value=""></input> <input type="hidden"
	name="curWebUser" value=""></input> <input type="hidden"
	name="curDBUser" value=""></input> <input type="hidden" name="opType"
	value=""></input> <input type="hidden" name="curDB" value=""></input>
<div id="dbconfigView">
<div class="divMainSectionTitle">Database & User Configuration</div>
<div class="fieldbox">
<div> 
  <div style="text-align: center; margin-bottom: 5px; padding-top: 5px;">
    <bean:define id="dbConfigList" name="udcForm"
	   property="dbConfigSelector.dbConfigList" type="java.util.Collection" />
    <span class="label">Database: </span> <html:select name="udcForm"
	  property="dbConfigSelector.selectedDBId" onchange="dbConfChanged(this)">
	  <html:options collection="dbConfigList" property="value"
		  labelProperty="label" />
     </html:select> &nbsp; 
      <html:submit styleClass="submit-button"
	        onclick="return go(this,'viewAddDatabase')">
	         <bean:message key="button.dbconf.add.db" />
      </html:submit> 
      <c:if test="${not udcForm.curDBConfig.defaultDB}">
         &nbsp;
         <input type="submit" class="submit-button" value="Remove"
		onclick="return go(this,'removeDBConf')" />
       </c:if> 
       <span id="help_9"><button onclick="return helpHandler('help_9')">
         <img align="middle" class="help_button" src="<%=request.getContextPath()%>/pages/images/questionmark.png" width="19" height="19"></button>
       </span>
  </div>

  <div><span class="label">Database ID:</span> <c:out
	value="${udcForm.curDBConfig.id}" />
  </div>
<div><span class="label">Database Type:</span> <c:out
	value="${udcForm.curDBConfig.dbType}" /></div>
<div><span class="label">Database URL:</span> <c:out
	value="${udcForm.curDBConfig.dbURL}" /></div>
<div><span class="label">Site Name (SiteID):</span> <c:out
	value="${udcForm.curDBConfig.siteName}" /> (<c:out
	value="${udcForm.curDBConfig.siteID}" />)</div>
</div>
<div id="dbUserView">
<div class="divSectionTitle">Database Users</div>
<c:if test="${empty udcForm.curDBConfig.dbUsers}">
	<div><input type="submit" class="submit-button"
		value="Add New Database User"
		onclick="return viewAddEditDbUser(this,'','add')"></div>
</c:if> <c:forEach var="dbUser" items="${udcForm.curDBConfig.dbUsers}">
	<div style="padding-top: 5px;"><span class="label">User:</span>
	<c:out value="${dbUser.name}" /> <%-- 
	           &nbsp;
	           <input type="submit" class="submit-button" value="Edit"
	               onclick="return viewAddEditDbUser(this,'<c:out value="${dbUser.name}"/>','edit')" >
	           --%>
	<div style="margin-left: 10px;">
	<div class="divSectionTitle">Web Application Users</div>
	<div><input type="submit" class="submit-button"
		value="Add New User"
		onclick="return viewAddEditWebUser(this,'<c:out value="${webUser.name}"/>','add')">
	</div>
	<c:forEach var="webUser" items="${udcForm.curDBConfig.webUsers}">
		<c:if test="${webUser.dbUser.name == dbUser.name}">
			<div style="margin: 3px; border: 1px #00659c solid; padding: 3px;">
			<span class="label">User:</span> <c:out value="${webUser.name}" />
			&nbsp; <c:if test="${webUser.useGSI}">
				<span style="color: red;">(GSI)</span> &nbsp
		        </c:if> <input type="submit" class="submit-button" value="Edit"
				onclick="return viewAddEditWebUser(this,'<c:out value="${webUser.name}"/>','edit')">
			<c:if test="${webUser.name != 'admin'}">   
	              &nbsp;
	              <input type="submit" class="submit-button" value="Remove"
					onclick="return removeWebUser(this,'<c:out value="${webUser.name}"/>','<c:out value="${dbUser.name}"/>')">
			</c:if> <c:choose>
				<c:when test="${not empty webUser.privileges}">
					<div style="margin-left: 10px;">
					<div class="divSectionTitle">Privileges</div>
					<table border="0">
						<tr>
							<c:forEach var="priv" items="${webUser.privileges}">
								<td>
								<div
									style="border: 1px #00659c dotted; padding-left: 3px; padding-right: 3px;">
								<c:out value="${priv.name}" /> <input type="checkbox"
									name="<c:out value="${webUser.name}.${priv.name}"/>" /></div>
								</td>
							</c:forEach>
							<td><input type="submit" class="submit-button"
								value="Remove Checked"
								onclick="return go1(this,'Remove Checked','<c:out value="${webUser.name}"/>')">
							</td>
						</tr>

					</table>
					<c:if test="${not empty webUser.missingPrivileges}">
					   <c:if test="${not empty webUser.nonProjectMissingPrivileges}">
						<div style="margin-top:5px;"><span class="label">Privilege: </span> <select
							name="<c:out value="${webUser.name}.privSelector"/>"
							multiple="multiple">
							<c:forEach var="priv" items="${webUser.missingPrivileges}">
								<c:if test="${not priv.projSpec and priv.name ne 'admin'}">
									<option><c:out value="${priv.name}" /></option>								
								</c:if>
							</c:forEach>
						</select> &nbsp; <%-- button.dbconf.add.priv  --%> <input type="submit"
							class="submit-button" value="Add"
							onclick="return go1(this,'Add Privilege','<c:out value="${webUser.name}"/>')" />
						</div>
						</c:if>
						<div>
						<c:set var="ppMatMan" value="${udcForm.ppMatrixManMap[webUser.name]}" /> 
				        <c:forEach var="uppm" items="${ppMatMan.userProjectPrivMatrixList}">
					      <table class="priv_table">
						    <thead>
							  <tr>
								<th>Privilege</th>
								<c:forEach var="ei" items="${uppm.experiments}">
									<th>
									<div><c:out value="${ei.name}" /></div>
									</th>
								</c:forEach>
							  </tr>
							<thead>
							<tbody>
								<c:forEach var="pe" items="${webUser.privExperiments}">
									<tr>
										<td><c:out value="${pe.privilege}" /></td>
										<c:forEach var="pps" items="${uppm.privStatusListMap[pe.privilege]}">
										  <td>
											<div><c:if test='${pps.granted}'>
												<input type="checkbox"
													name="<c:out value="${webUser.name}.${pe.privilege}.${pps.expId}"/>"
													checked />
											</c:if> <c:if test='${not pps.granted}'>
												<input type="checkbox"
													name="<c:out value="${webUser.name}.${pe.privilege}.${pps.expId}"/>" />
											</c:if></div>
										   </td>
										</c:forEach>
										</tr>
								</c:forEach>
							</tbody>
					  </table>					
				</c:forEach>
						<div style="text-align: right; margin: 3px 3px;"><input
							type="submit" class="submit-button" value="Save"
							onclick="return go1(this,'Save Privileges','<c:out value="${webUser.name}"/>')" />
						</div>
						</div>
					</c:if></div>
				</c:when>
				<c:otherwise>
					<c:if test="${not empty webUser.missingPrivileges}">
					    <c:if test="${not empty webUser.nonProjectMissingPrivileges}">
						<div style="margin-top:5px;"><span class="label">Privilege: </span> 
						<select
							name="<c:out value="${webUser.name}.privSelector"/>"
							multiple="multiple">
							<c:forEach var="priv" items="${webUser.missingPrivileges}">
							    <c:if test="${not priv.projSpec and priv.name ne 'admin'}">
								 <option><c:out value="${priv.name}" /></option>
								</c:if>
							</c:forEach>
						</select> &nbsp; <%-- button.dbconf.add.priv  --%> <input type="submit"
							class="submit-button" value="Add"
							onclick="return go1(this,'Add Privilege','<c:out value="${webUser.name}"/>')" />

						</div>
						</c:if>
						<div>
						<c:set var="ppMatMan" value="${udcForm.ppMatrixManMap[webUser.name]}" /> 
				        <c:forEach var="uppm" items="${ppMatMan.userProjectPrivMatrixList}">
					      <table class="priv_table">
						    <thead>
							  <tr>
								<th>Privilege</th>
								<c:forEach var="ei" items="${uppm.experiments}">
									<th>
									<div><c:out value="${ei.name}" /></div>
									</th>
								</c:forEach>
							  </tr>
							<thead>
							<tbody>
								<c:forEach var="pe" items="${webUser.privExperiments}">
									<tr>
										<td><c:out value="${pe.privilege}" /></td>
										<c:forEach var="pps" items="${uppm.privStatusListMap[pe.privilege]}">
										  <td>
											<div><c:if test='${pps.granted}'>
												<input type="checkbox"
													name="<c:out value="${webUser.name}.${pe.privilege}.${pps.expId}"/>"
													checked />
											</c:if> <c:if test='${not pps.granted}'>
												<input type="checkbox"
													name="<c:out value="${webUser.name}.${pe.privilege}.${pps.expId}"/>" />
											</c:if></div>
										   </td>
										</c:forEach>
										</tr>
								</c:forEach>
							</tbody>
					  </table>					
				</c:forEach>
						<div style="text-align: right; margin: 3px 3px;"><input
							type="submit" class="submit-button" value="Save"
							onclick="return go1(this,'Save Privileges','<c:out value="${webUser.name}"/>')" />
						</div>
						</div>

					</c:if>
				</c:otherwise>
			</c:choose>
			</div>
		</c:if>
	</c:forEach> <%-- WebUsers section end --%></div>
	</div>
</c:forEach>
</div>
</div>
</div>


</form>

<script>
     var divElem = jQuery('#dbconfigView')[0];
     Rico.Corner.round( divElem,  {color: "#00659c", corners: 'top bottom'});
</script>
