<%@ page contentType="text/html;charset=UTF-8" language="java" %>
<%@ taglib uri="/WEB-INF/struts-bean.tld" prefix="bean" %>
<%@ taglib uri="/WEB-INF/struts-html.tld" prefix="html" %>
<%@ taglib uri="/WEB-INF/struts-logic.tld" prefix="logic" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jstl/core" %>

<link rel="stylesheet" type="text/css" href="layout/jquery-ui.css">
<link rel="stylesheet" type="text/css" href="yui/assets/skins/sam/skin.css">
<link rel="stylesheet" type="text/css" href="yui/assets/skins/sam/button.css">

<link rel=stylesheet
	href="<%=request.getContextPath()%>/pages/layout/cas.css" type="text/css">

<%--
<script type="text/javascript"
   src="<%=request.getContextPath()%>/pages/yui/yahoo-dom-event/yahoo-dom-event.js"></script>
<script type="text/javascript"
   src="<%=request.getContextPath()%>/pages/yui/connection/connection-min.js"></script>
<script type="text/javascript"
   src="<%=request.getContextPath()%>/pages/yui/element/element-min.js"></script>
<script type="text/javascript"
   src="<%=request.getContextPath()%>/pages/yui/dragdrop/dragdrop-min.js"></script>
<script type="text/javascript"
   src="<%=request.getContextPath()%>/pages/yui/container/container-min.js"></script>
--%>
<script type="text/javascript"
   src="<%=request.getContextPath()%>/pages/jquery-ui-1.10.2.js"></script>

<script type="text/javascript"
   src="<%=request.getContextPath()%>/pages/jquery.ba-tinypubsub.js""></script>

<script type="text/javascript"
   src="<%=request.getContextPath()%>/pages/cas.js"></script>

<style>
 #templates {
  display:none;
 }

/*
 #bug-report-dlg {
    display:none;
 }

 .yui-pe .yui-pe-content {
    display:none;
}
*/

  div #caEntry {
     display: none;
  }
  #caBuilder, #doneButton {
     display: none;
  }

</style>


<script>
    var usi = <c:out value="${cuForm.usiJSON}" escapeXml="false" />;
    var esi = <c:out value="${cuForm.esiJSON}" escapeXml="false" />;
    var alObj= <c:out value="${cuForm.asiListJSON}" escapeXml="false" />;
    var asiList = alObj.asiList;
    alObj = null;

    function prepSeriesTable(container, protocols) {
      var shi, i;
      for(i = 0; i < usi.shiList.length; i++) {
        shi = usi.shiList[i];
        var tr = jQuery('<tr></tr>').appendTo(container);
        jQuery('<td></td>').text(shi.name).attr('id','seriesName_' + i).appendTo(tr);
        var seriesTypeTD = jQuery('<td></td>').appendTo(tr);
        jQuery('div.template.protocolChooser').children().clone().appendTo(seriesTypeTD);
        jQuery('select[name="pChooser"]',seriesTypeTD).attr('id','pChooser_' + i);
        var selEl$ = jQuery('select',seriesTypeTD); 
        jQuery.populateSelect(selEl$[0], protocols, function(o) {
          return {name : o.name, value: o.name };    
        });
        if (shi.seriesType) {
          jQuery(selEl$).val(shi.seriesType);
        }else {
          jQuery(selEl$).val('Unknown'); 
        }
         
        tr.data('suffix','.' + i);
        var tsTD = jQuery('<td></td>').appendTo(tr);
        var inputDiv = jQuery('div.template.seriesTimestamp').children().clone().val(shi.scanDate).appendTo(tsTD);
        jQuery('input[name="timestamp"]', tsTD).attr('id', 'timestamp_' + i); 
      } 
    } 

 function prepVisitInfo(userAssessments) {
   var projIdx = jQuery('#project')[0].selectedIndex;
   var sbjIdx = jQuery('#subjectID')[0].selectedIndex;
   var  project = esi.experiments[projIdx];
   var  subject = project.enrolledSubjects[sbjIdx]; 
   var visitDate = jQuery('#visitDate').val();
   var rg = jQuery.grep(project.rgiList, function(o) { return o.name == subject.rg; } )[0];
   var scannerType = jQuery('#scanner').val();
   var i, shi;
   var vi = {visitId:-1, name:'', descr:'', subjectID: subject.subjectID,
             expId: project.expId, visitType:'scan', visitDate: visitDate + " 00:00",
            rgInfo: {name: rg.name, descr: rg.descr},
            siList:[],
            assessments:[],
            extraFiles:[],
            scannerType: scannerType,
            hasAnat:false, hasFM:false
            };  
    var selScanner = jQuery(esi.ceiList,
               function(o) { var t = o.model + ' ' + make; return t === scannerType} )[0];
    for(i = 0; i < usi.shiList.length; i++) {
        var shi = usi.shiList[i];
        var seriesType = jQuery('#pChooser_' + i).val();
        var seriesTS = jQuery('#timestamp_' + i).val();
        
        var pi = jQuery.grep(esi.protocolList, 
           function(o) { return o.name === seriesType })[0];
        var si = {name: seriesType, descr:'',
          protocolId:pi.protocolId , protocolVersion:pi.version,
          timestamp:seriesTS,
          colEqId:selScanner.id,
          seriesName: shi.name,
          shi:''};   
          vi.siList.push(si);
    }
    var gender = jQuery('#gender').val();
    var diagnosis = jQuery('#diagnosis').val();
    var at = {name:'Subject Information', 
          descr:'Minimal set of demographics information',
          scores:[{name:'age', type:'int', descr:'Age in years'},
             {name:'gender', type:'string', descr:'Age in years'},
             {name:'diagnosis', type:'string', descr:'Diagnosis'}
          ],
          values:[ {name:'age',value:''},
                  {name:'gender',value:gender},
                  {name:'diagnosis',value:diagnosis} ]
          };
    vi.assessments[0] = at;
    if (userAssessments) {
       for(i = 0; i < userAssessments.length; i+= 1) {
           vi.assessments.push(userAssessments[i]);
       }
    }
    return vi;
 }

 function getVisitDate(scanDate) {
      if (scanDate) {
         var arr = scanDate.split(' ');
         return arr[0];
      }
      return null;
 }

jQuery(function() {
       prepSeriesTable(jQuery('#seriesTable'), esi.protocolList);
       
       var userAssessments = [];
       var visitDate = getVisitDate(usi.shiList[0].scanDate);
       jQuery('#visitDate').val(visitDate);
       jQuery('#visitDate').datepicker(
          {changeMonth:true, changeYear: true }
       ); 

       var projSelEl = jQuery('#project')[0];

       jQuery.populateSelect(projSelEl, esi.experiments, function(o) {
          return {name: o.name, value: o.expId };
       });
       
       jQuery('#subjectID').bind('change',esi, function(event) {
          var projIdx = jQuery('#project')[0].selectedIndex;
          var sbjIdx = jQuery(this)[0].selectedIndex;
          var diagSel = jQuery('#diagnosis')[0];
          jQuery.populateSelect(diagSel, esi.experiments[projIdx].rgiList, 
            function(o) { return {name: o.name, value: o.name} });
          if (sbjIdx >= 0) {
            var rg = esi.experiments[projIdx].enrolledSubjects[sbjIdx].rg;
            jQuery(diagSel).val(rg);
            jQuery('#gender').val(esi.experiments[projIdx].enrolledSubjects[sbjIdx].gender);
          }
       });
     
       jQuery(projSelEl).bind('change', esi, function(event) {
           var idx = jQuery(this)[0].selectedIndex;
           var selEl = jQuery('#subjectID')[0];
           var x = event.data;
           jQuery.populateSelect(selEl, 
              event.data.experiments[idx].enrolledSubjects, function(o) {
               return {name: o.subjectID, value: o.subjectID};
           });
           jQuery(selEl).trigger('change');
       });
       jQuery('#project').trigger('change');

       var scanSel = jQuery('#scanner')[0];
       jQuery.populateSelect(scanSel, esi.ceiList, function(o) {
          return {name: o.make + ' ' + o.model, value: o.id };
       },'-- Please Select a Scanner --');

       // if available use scanner info
       if (usi.scannerInfo) {
    	   var foundList = jQuery.grep(esi.ceiList, function(o) {
               var name =  o.make + ' ' + o.model;
               return name === usi.scannerInfo; 
           });
           if (foundList && foundList.length > 0) {
               jQuery(scanSel).val(foundList[0].id);
           }
       }

       jQuery(scanSel).bind('change', function(event) {
          jQuery('option[value=""]',this).remove();
       });

       var validateTS = function(str) {
           if (jQuery.isBlank(str) || str.indexOf(' ') == -1) {
              return false;
           }
           var toks = str.split(' ');
           if (toks.length != 2) {
               return false;
           }
           return jQuery.isValidDate(toks[0]) && jQuery.isValidTime(toks[1]); 
       };

       var validate = function() {
          var errMsg = '',
            vds = jQuery('#visitDate').val(),
            scanner = jQuery('#scanner').val(),
            shi, i;
          if (jQuery.isBlank(vds)) {
              errMsg += "Visit Date cannot be empty!\n";
          } else if (!jQuery.isValidDate(vds)) {
              errMsg += "Visit Date does not have a valid date format (" + vds + ")!\n";
          }
           
          if (jQuery.isBlank(scanner)) {
              errMsg += "A scanner must be selected from the list!\n";
          }
          
          for(i = 0; i < usi.shiList.length; i++) {
             var seriesType = jQuery('#pChooser_' + i).val();
             var seriesTS = jQuery('#timestamp_' + i).val();
             var seriesName = jQuery('#seriesName_' + i).text();
             if (!validateTS(seriesTS)) {
               errMsg += "Bad timestamp for series '" + seriesName + "' (" + seriesTS + ")!\n";
             }
             if ( jQuery.isBlank(seriesType) || seriesType === 'Unknown') {
                errMsg += "A valid series type needs to be provided for series '" + seriesName + "'!\n";  
             }
          }

          if (!jQuery.isBlank(errMsg)) {
             alert("Please correct the following error(s) before proceeding!\n\n" +
                    errMsg);
             return false;       
          }
          return true;
       };

       var handleBugRepSubmit = function() {
            this.cancel();
       };

       var stagingId = usi.stagingId;
       jQuery('#submitButton').bind('click', function(event) {
           if (!validate()) {
               return false;
           }
           var vi = prepVisitInfo(userAssessments);
           // check for duplicate visits
           var vd = vi.visitDate.split(' ')[0];
           var hasDuplicateVisit = false;
           jQuery.ajax({ url:'<html:rewrite page="/cbfupload.do"/>',
               async:false, data:{subjectID: vi.subjectID, expID: vi.expId,
                   visitDate: vd, action:'checkIfVisitExists'}, dataType:'json', 
                   }).done(function(data) {
               if (data.visitExists && data.visitExists === 'yes') {
                   hasDuplicateVisit = true;
               }
           });
           var canContinue = !hasDuplicateVisit; 
           if (hasDuplicateVisit) {
        	   canContinue =  confirm("A visit with the same date already exists.\n" + 
               "Do you want to add a new visit?");
           }
           if (!canContinue) {
               return false;
           }
           var formEl$ = jQuery('#cuf');
           var js = JSON.stringify(vi);
           jQuery("input[name='visitInfo']",formEl$).attr("value",js);
           jQuery("input[name='stagingId']",formEl$).attr("value",stagingId);
           return true;
       });


       var ae = new cas.AsEntryManager(asiList);
       jQuery('#saveAsEntry').click(ae, function(event) {
          event.preventDefault();
          var asName = jQuery('#asFilter option:selected').text();
          var visitInfo = {}; // just a place holder
          event.data.saveAssessment(jQuery('#asEntryPanel'), asName, visitInfo);
          userAssessments.push(visitInfo.assessments[0]); 
       });

       jQuery.subscribe('newAssessment', function(e, asName) {
          var span$ = jQuery('#asStatus');
          var asList = span$.data('list') || [];
          asList.push(asName);
          var txt = 'Saved assessments (' + asList.length + ')';
          span$.text(txt);
          var i, titleTxt = asList[0];
          for(i = 1; i < asList.length; i+= 1) {
             titleTxt += "," + asList[i];
          }
          span$.attr('title',titleTxt);
          span$.data('list', asList);
       });

       jQuery('body').on({
         ajaxStart: function() {
            jQuery(this).addClass("loading");
         },
         ajaxStop:  function() {
           jQuery(this).removeClass("loading");
         }
       });

       jQuery('#addAsData').click(function(event) {
          event.preventDefault();
          jQuery(this).hide();
          jQuery('#doneButton').show();
          jQuery('#caEntry').show('slow');
       });

       jQuery('#doneButton').click(function(event) {
          event.preventDefault();
          jQuery('#caEntry').hide('slow');
          jQuery(this).hide();
          jQuery('#addAsData').show();
       });
});

</script>
<style>
</style>

<div class="error">
    <html:errors/>
</div>

<div id="uploadPane" class="mainPanel">
  <div class="headerPane">
      <div class="mlarge" style="margin:0 0 0 5px; padding:0;">CBF Data Upload</div>
  </div>
<html:form action="/cbfupload" styleId="cuf"> 
   <input type="hidden" name="action" value="uploadVisit" />
   <input type="hidden" name="stagingId" value="" />
   <input type="hidden" name="visitInfo" value="" />


  <div class="input_div">
      <div class="button_div">
          <span id="asStatus"></span>&nbsp;
          <button id="addAsData" 
               class="submit-button">Add Clinical Assessment(s)</button>
          <button id="doneButton" 
               class="submit-button">Done</button>
      </div>
      <div id="caEntry">
        <fieldset id="cabPane">
           <legend>Assessment Entry</legend>
           <div class="buttonBar">
              <label for="asFilter">Assessment:</label>
              <select id="asFilter" name="asFilter" class="asChooser" title="Select an assessment">
              </select>
              &nbsp;
              <button id="saveAsEntry" class="submit-button">Save</button>
             <%-- 
              &nbsp;
            <button id="createNewAs" >New Assessment Type</button>
            --%>
           </div>
        
          <div id="asEntryPanel">
          </div>
        </fieldset>
      </div>

      <div id="caBuilder">
        <fieldset id="cabPane">
           <legend>Clinical Assessment Builder</legend>
           <div class="input_div"> 
              <label class="label1" for="asName">Name:</label>
              <input type="text" id="asName" name="asName" placeholder="Assessment Name" value="" />
           </div>
           <div class="input_div"> 
              <label class="label1" for="asDesc">Description:</label>
              <textarea id="asDesc" name="asDesc" 
                 placeholder="A description for the assessment" cols="30" rows="3"></textarea>
              <div class="buttonBar">
                 <button type="button" id="addScore">Add Score</button>
                 <button type="button" id="createAs">Create Assessment</button>
              </div>
              <div id="scoreBuildPanel">
              </div>
           </div>
        </fieldset>
      </div>
  </div>
 <div class="input_div">
        <fieldset style="border:1px black solid; margin-right:5px;">
              <legend style="border:1px black solid; margin-left:1em; padding:0.2em 0.8em;">Visit Info</legend>
             <div class="input_div">
             <label for="subjectID">Subject ID:</label>
             <select name="subjectID" id="subjectID">
             </select>  &nbsp;
             <label>Project:</label>
             <select name="project" id="project">
             </select>
             </div>

             <div class="input_div">
             <label>Visit Date (mm/dd/yyyy):</label>
             <input type="text" name="visitDate" id="visitDate" value="" size="10" title="Visit Date in mm/dd/yyyy format"></input>
             &nbsp;
             <label>Gender:</label>
             <select name="gender" id="gender">
                <option value="Male">Male</option>
                <option value="Female">Female</option>
             </select>
             </div>

             <div class="input_div">
             </div>

             <div class="input_div">
                <label>Scanner:</label>
                <select name="scanner" id="scanner">
                   <option>-- Please Select a Scanner --</option>
                </select>
                &nbsp;
                <label>Diagnosis:</label>
                <select name="diagnosis" id="diagnosis">
                </select>
             </div>
        </fieldset>
    <%--     
        <div class="button_div">
            <button id="bug-report-btn" 
               class="submit-button">Report Bug/Request Feature</button>
        </div>
    --%>
        <div class="input_div">
            <table id="seriesTable" style="border-width:0;">
               <tr>
                   <th>Series</th>
                   <th>Standard Name</th>
                   <th>Timestamp (mm/dd/yyyy hh:mm)</th>
               </tr>
            </table>

        </div>
     </div>
     <div class="button_div">
            <input type="submit" class="submit-button" value="Submit"
               id="submitButton" />
    </div>
</html:form>
</div>

<div class="modal"></div>

<div id="templates">
     <div class="template protocolChooser">
        <select name="pChooser" title="Select the Series Type">
        </select>
     </div>
     <div class="template seriesTimestamp">
          <input name="timestamp" type="text" size="16">
     </div>

      <div class="template scoreRemover">
           <button type="button" class="scoreRemover"
            title="Remove this score"></button>
      </div>
      <div class="template sfbuild">
          <label>Score:</label>
          <input type="text" name="scoreName" value=""/>
          &nbsp;
          <label>Score Type:</label>
          <select name="scoreTypeSel" title="Select a score type">
               <option value="varchar" selected="selected">String</option>
               <option value="integer">Integer</option>
               <option value="float">Real</option>
          <%--     <option value="timestamp">Date</option>
               <option value="boolean">Boolean</option>
           --%>
          </select>
      </div>
      
      <div class="template string">
           <label></label>
           <input type="text" name="score" value=""/>
      </div> 
      <div class="template numeric">
         <label></label>
        <input type="text" name="score" class="numeric"/> 
      </div>

     <div class="template boolean">
         <label></label>
        <input type="radio" name="score" value="yes" checked="checked"/> <span>Yes</span>
        <input type="radio" name="score" value="no"/> <span>No</span>
      </div>
      <div class="template date">
         <label></label>
           <input type="text" name="score"/> 
           <input type="button" name="dateScoreBut" title="Calendar Pop-up" value="...">
      </div>

</div>
 
</div>

<script>
     var divElem = jQuery('#uploadPane')[0];
     var options = {color: "#ffcc33", corners: 'top'};
     Rico.Corner.round( divElem, options );
     Rico.Corner.round( divElem,  {color: "#d3d3d3", corners: 'bottom'});
</script>
