// requires prototype, clinical.js, utils.js

var qbuilder = new Object();

// asSelectorName : 'assessmentSel'
//
qbuilder.AssessmentQueryBuilder=function(instVarName, asiList, asSelectorName, 
    idPrefix, selectors) {
    this.instVarName = instVarName;
	 this.asSelectorName = asSelectorName;
	 this.asiList = asiList;
	 this.idPrefix = idPrefix || '';
	 this.scoreNames = null;
	 this.selectors = selectors;
	 if (!this.selectors) {
	     this.selectors = { 'scpSel':'scp','qbpSel':'qbp'};
	 }
}

qbuilder.AssessmentQueryBuilder.prototype.handleAssessmentQPanelPopulation=function() {
     var asSelector = $(this.asSelectorName); // assessmentSel
     if (!asSelector) return;
	  var asiSelIdx = 0;
     if (asSelector.options.length == 0) {
	     for(var i = 0; i < this.asiList.length; i++) {
		     var asi = this.asiList[i];
			  var option = new Option(asi.name, asi.asId);
			  if (i == 0) {
				  option.selected = true;
				  asiSelIdx = i;
			  }
			  try {
				  asSelector.add(option,null);
			  } catch(e) {
				  asSelector.add(option,-1);
			  }
	     }
     }
	  this.prepScorePanel(asiSelIdx,this.selectors.scpSel);
}

qbuilder.AssessmentQueryBuilder.prototype.handleAssessmentChange=function() {
	  var asiSelector = $(this.asSelectorName); // 'assessmentSel';
	  if (!asiSelector) return;
	  this.prepScorePanel(asiSelector.selectedIndex, this.selectors.scpSel);
}

qbuilder.AssessmentQueryBuilder.prototype.prepScorePanel=function(asiSelIdx, divId) {
   var scores = this.asiList[asiSelIdx].scores;
	this.scoreNames = new Array();
	for(var i = 0; i < scores.length; i++) {
			this.scoreNames[i] = scores[i].name;
	}
	new Autocompleter.Local(this.idPrefix + 'scoreField', this.idPrefix + 'autoCompleteMenu', 
            this.scoreNames, {choices : 20} );	 
}


qbuilder.AssessmentQueryBuilder.prototype.setScoreField=function(value) {
     var scoreField = $(this.idPrefix + 'scoreField');
     if ( scoreField) {
        scoreField.value = value;
        var div = $(this.selectors.scpSel); // scp
        if (div && div.popupViewer)
             div.popupViewer.hide();
     }
     return false;
  }
  
qbuilder.AssessmentQueryBuilder.prototype.showAllScores=function(evt, elem) {
	  if (!elem) return false;
	  if (!this.scoreNames) return false;
     var mx = 0, my = 0;
     if (!evt) 
       evt = window.event;
     if (evt.pageX || evt.pageY)      {
       mx = evt.pageX;
       my = evt.pageY;
     } else if (evt.clientX || evt.clientY)   {
       mx = evt.clientX + document.body.scrollLeft
         + document.documentElement.scrollLeft;
       my = evt.clientY + document.body.scrollTop
         + document.documentElement.scrollTop;
     }
	  var content = "<table border='0' cellspacing='0' cellpadding='2'>";
     var noCols = 2;
     var noRows = Math.floor(this.scoreNames.length / noCols);
     if ( (this.scoreNames.length % noCols) > 0) noRows++;
     for(var i = 0; i < noRows; i++) {
		  content += "\n<tr>";
		  for(var j = 0; j < noCols; j++) {
			  content += "<td>";
			  var idx = i * noCols + j;
			  if ( idx < this.scoreNames.length)  {
              content += "<a href='javascript:{}' class='selectionlink' onclick=\"return "
				   + this.instVarName + ".setScoreField('" + this.scoreNames[idx]
                        + "');\">" + this.scoreNames[idx] + "</a>";
              
			  } else { content += "&nbsp;"; }
			  content += "</td>"
		  }	
		  content += "</tr>";
	  }
     bal.Popup.showPopup(mx, my, elem.parentNode, content);
     return false;
  }

qbuilder.AssessmentQueryBuilder.prototype.handleAddQueryPart=function() {
	  var asiSelector = $(this.asSelectorName);
	  if (!asiSelector) return;
	  var scoreField = $('scoreField');
	  if (!scoreField || !scoreField.value) {
		  //TODO show validation message
		  return false;
	  }
	  var asi = this.asiList[ asiSelector.selectedIndex ];
	  var score = this.findScore(asi, scoreField.value);
	  if (!score) {
		  alert("Not a valid score:" + scoreField.value);
		  scoreField.value='';
		  return false;
	  }
	  var div = $(this.selectors.qbpSel); //'qbp'
	  var aqpId = asi.name.replace(/\s+/g,'_');
	  //alert('aqpId:' + aqpId);
	  var asiQPartPanel = $(aqpId);
	  if (!asiQPartPanel) {
		  asiQPartPanel = utils.newDomNode('div', aqpId);
		  div.appendChild(asiQPartPanel);
		  new Insertion.Bottom(asiQPartPanel,
			  "<p><b>" + asi.name + "</b></p>");
	  }
	  var useConnector = this.isConnectorRequired();
	  
	  var idPrefix = asi.asId + "__" + score.name.replace(/\s+/g,':');
	  var ajaxResults = new Array();
	  var url = '<html:rewrite page="/caquery.do?actionParam=getScorecodes"/>';
	  new Ajax.Request(url,  { method:"get", asynchronous: false, 
			  encoding: 'ISO-8859-1', evalJSON : false,
			  parameters: {asID: asi.asId, scoreName: score.name},
			  onSuccess: function(response) {
					 var ro = eval('(' + response.responseText + ')');					 
					 if (ro.hasEnums)  {
				      ajaxResults.push( ro );
					 }
			  },
			  onException: function(transport,e){
				  // no op
		     }			
		  });
	  this.addQueryPart(asiQPartPanel, idPrefix, score.name, score.type, useConnector, ajaxResults); 
	  
	  scoreField.value='';
	  return false;
}  
qbuilder.AssessmentQueryBuilder.prototype.findScore=function(asi, scoreName) {
	  var list = asi.scores;
	  for(var i = 0; i < list.length; i++)
		  if (list[i].name == scoreName)
		     return list[i];
	  return null;
  }
  
qbuilder.AssessmentQueryBuilder.prototype.isConnectorRequired=function() {
	  var div = $(this.selectors.qbpSel); //'qbp'
	  var els = div.getElementsByTagName('div');
	  if (!els) return false;
	  for(	var i = 0; i < els.length; i++) {
		  var scoreDivs = els[i].getElementsByTagName('div');
		  if ( scoreDivs && scoreDivs.length > 0) return true;		 
     }
	  return false;
  }
  
  
qbuilder.AssessmentQueryBuilder.prototype.addQueryPart=function(container, idPrefix, colName, colType, useConnector, ajaxResults, opCode, rhsValue) {
     var divId = idPrefix + "__qp";
     if ( $(divId) ) {
       return;
     }
     var div = utils.newDomNode('div', divId);
     container.appendChild(div);
     if ( useConnector) {
        var rbDivId = idPrefix + "__connector";
        var rbDiv = utils.newDomNode('div',rbDivId);
        div.appendChild(rbDiv);
        var andButton = utils.newRadioBut(idPrefix + "__and",rbDivId, "AND","AND",true);
        var orButton = utils.newRadioBut(idPrefix + "__or",rbDivId, "OR","OR",false);
        rbDiv.appendChild(andButton);
        new Insertion.After(andButton,"&nbsp;");
        rbDiv.appendChild(orButton);        
     }
     new Insertion.Bottom(div,colName + " &nbsp;");
     if (colType != 'varchar') {
        var opts = [ {value:1, label:'='}, {value:2, label:'>'} ,
          {value:3, label:'<'}, {value:4, label:'<>'},
          {value:5, label:'>='}, {value:6, label:'<='}];
          var sel = utils.createSelect(idPrefix + "__operator", opts);          
          div.appendChild( sel );
			 if (ajaxResults && ajaxResults.length == 1) {
				 var enumOpts = [];
				 var enums = ajaxResults[0].sci;
				 enumOpts.push( {value: '*', label: '*'});
				 for(var i = 0; i < enums.length; i++) 
					 enumOpts.push( {value: enums[i].c, label : enums[i].l} );
				 var enumSel = utils.createSelect(idPrefix + "__enums", enumOpts);
				 new Insertion.Bottom(div, "&nbsp;");
				 div.appendChild( enumSel );
				  var html = "&nbsp;<input type='button' class='submit-button' name='Remove' value='Remove' "
				  + "onclick=\"return qb.removeQueryPart('"+ divId + "');\"></input>";
				  new Insertion.Bottom(div,html);
				  if (rhsValue) {					   
					   for(var i = 0; i < enumSel.options.length; i++) 
						   if (enumSel.options[i].value == rhsValue) enumSel.options[i].selected = true;
						   else enumSel.options[i].selected = false;
				  }
			 } else {
				 new Insertion.Bottom(div, "&nbsp; <input type='text' id='" 
					 + idPrefix + "__rhs' size='8' value='*'></input>");
				 var html = "<br> <span style='margin-left:50px; line-height:1.5em;' >" 
				 + "Between <input type='text' id='" + idPrefix + "__lb' size='8' value=''>"
				 + " and "	 
				 +  "<input type='text' id='" + idPrefix + "__ub' size='8' value=''>&nbsp;"
				 +  "<input type='button' class='submit-button' name='Remove' value='Remove' onclick=\"return qb.removeQueryPart('"
				 + divId + "');\"></input>"; 
				 new Insertion.Bottom(div,html);
				 if (rhsValue) {
						$(idPrefix + "__rhs").value = rhsValue; 
				 }
			 }
			 if (opCode) {
				 for(var i = 0; i < sel.options.length; i++) 
					 if (sel.options[i].value == opCode) sel.options[i].selected = true;
					 else sel.options[i].selected = false;
			 }
     } else {
		  var opts = [ {value:1, label:'='}, {value:100, label:'starts with'} ,
          {value:101, label:'ends with'}, {value:102, label:'any of'}];
        var sel = utils.createSelect(idPrefix + "__operator", opts);          
		  div.appendChild( sel );
     
        new Insertion.Bottom(div, "&nbsp; <input type='text' id='" 
        	    + idPrefix + "__rhs' size='12' value='*'></input>&nbsp;"
				 + "<input type='button' class='submit-button' name='Remove' value='Remove' onclick=\"return qb.removeQueryPart('"
				 + divId + "');\"></input>"); 
     }
}

qbuilder.AssessmentQueryBuilder.prototype.buildQuery=function(verbose) {
     var asiSelector = $(this.asSelectorName); // 'assessmentSel'
     if ( !asiSelector) return;
     var div = $(this.selectors.qbpSel); //'qbp'
     var els = $A(div.getElementsByTagName('div'));
     if (!els) {
        alert("At least one criterion needs to be specified for querying!");
		  return false;
     }
     var aqJSON = "{asQPIList: [";
     var first = true;
     //var desc = "";
     //desc =els.inject(desc, function(s,value, idx) { 
     //  if (value && value.id) s += value.id + "\n"; return s; } );
     //alert("els:" + desc);
	  var count = 0;         
     for(var i = 0; i < els.length; i++) {
		   var asName = els[i].id.replace(/_/g,' ');
			var scoreDivs = els[i].getElementsByTagName('div');	
			for(var j = 0; j < scoreDivs.length; j++) {
				if (!scoreDivs[j] || !utils.strEndsWith(scoreDivs[j].id,"__qp")) continue;
				//alert("scoreDivs[" + j + "]:" + scoreDivs[j].id);
				var toks = scoreDivs[j].id.split('__');	
				if (!toks) continue;
				var asi = this.findAssessment(toks[0]);
				if(!asi) continue;
				var scoreName = toks[1].replace(/:/g,' ');
				var score = this.findScore(asi, scoreName);
				if(!score) continue;
	         var idPrefix = scoreDivs[j].id.replace(/__qp$/,'');                 
	         if (first) 
                first = false;
            else aqJSON += ", ";
				aqJSON += "{ asi: { name: '" + asi.name + "', asId:" + asi.asId + "},"
				+ "score:{ name: '" + score.name + "', type: '" + score.type + "'}, ";
				aqJSON += "connector: '";
				var andRB = $(idPrefix + "__and");
				if (andRB) {
					aqJSON += (andRB.checked) ? "AND'," : "OR',";
				} else {
					aqJSON += "NONE',";
				}
				//var selId = idPrefix + "__operator";
				//alert("selId:" + selId);
				var sel = $(idPrefix + "__operator");
				aqJSON += "operator: " + sel.options[sel.selectedIndex].value;
				var rhs = $(idPrefix + "__rhs");
				if (rhs && rhs.value) {
            	   var rhsVal = utils.trim(rhs.value);
						if ( rhsVal.length > 0) 
							aqJSON += ", rhs : '" + rhsVal + "'";		    
				} else {
					rhs = $(idPrefix + "__enums");
					if (rhs) 
						aqJSON += ", rhs : '" + rhs.options[rhs.selectedIndex].value + "'";
				}
				var lowBound = $(idPrefix + "__lb");
				if (lowBound && lowBound.value) {
					var val = utils.trim(lowBound.value);
					if ( val.length > 0)  
						aqJSON += ", lowBound: '" + val + "'";
				}		 
            var uppBound = $(idPrefix + "__ub");
				if (uppBound && uppBound.value) {
					var val = utils.trim(uppBound.value);
					if ( val.length > 0)  
						aqJSON += ", uppBound: '" + val + "'";
				}  
				aqJSON += "}\n";		
				count++;
			}// j
	  } //i
     aqJSON += "]}\n";
	  if (count == 0) {
		  alert("At least one score is necessary for querying clinical data!");
		  return null;			  
	  }
	  if(verbose) alert(aqJSON);
     return aqJSON;
}
  
qbuilder.AssessmentQueryBuilder.prototype.findAssessment=function(asId) {
	  for(var i = 0; i < this.asiList.length; i++) {
			if (this.asiList[i].asId == asId)
				return this.asiList[i];
	  }
	  return null;
}
