var clinical = clinical || {};

clinical.RoiAssocComp = function(roiList, jobList, rootEl$) {
	this.roiList = roiList;
	this.jobList = jobList;
	this.rootEl$ = rootEl$;
	this.roiCount = 0;
	this.assocCount = 0;
	var container$ = this.rootEl$, that = this;
	var subjects = jQuery.map(this.jobList, function(jr) {
		return jr.subject;
	});

	jQuery('button[name^="removeJob"]', container$).live('click', function() {
		jQuery(this).closest('div.racItem').remove();
	});

	jQuery('.roiAssocGroup [name]').live('suffixName', function() {
		var wr$ = jQuery(this), rag$ = wr$.closest('.roiAssocGroup');
		var suffix = rag$.data('suffix');
		var suffix2 = jQuery('.racItem', rag$).data('suffix2');
		if (/\w+\.\d+$/.test(wr$.attr('name'))) {
			return;
		}
		if (!suffix2) {
			wr$.attr('name', wr$.attr('name') + suffix);
		} else {
			wr$.attr('name', wr$.attr('name') + suffix + suffix2);
		}
	});

	jQuery.each(this.roiList, function(idx) {
		var rag$ = jQuery('<div></div>').addClass('roiAssocGroup').appendTo(
				container$);
		jQuery('div.template.roiAssoc').children().clone().appendTo(rag$);
		rag$.data('suffix', '.' + idx).data('idx', idx);
		jQuery('span.roiPath', rag$).html(this.brik);
		var selEl = jQuery('select.subjectSelector', rag$).get(0);
		jQuery.populateSelect(selEl, subjects, function(o) {
			return {
				name : o,
				value : o
			};
		});

		jQuery('button[name^="addJob"]', rag$).bind(
				'click',
				that,
				function(event) {
					var c$ = jQuery(this).closest('.roiAssocGroup');
					var selOpt = jQuery(':selected', jQuery(
							'select[name^="subjectSelector"]', c$));
					// alert("selOpt:" + selOpt);
					var subjectId = selOpt.val();
					event.data.addJobAssocComp(jQuery('div.sjaPanel', c$),
							subjectId);
				});
		jQuery(selEl).bind('change', that, function(event) {
			var c$ = jQuery(this).closest('.roiAssocGroup');
			jQuery('div.sjaPanel', c$).children().remove();
		});
	});

	var ew$ = jQuery('.roiAssocGroup [name]');
	ew$.trigger('suffixName');
	jQuery.each(this.roiList, function(idx) {
		if (typeof (this.subject) === 'undefined') {
			return;
		}
		var theSubject = this.subject, i, rac$, vj;
		var selector = 'select[name="subjectSelector.' + idx + '"]';
		var selWr$ = jQuery(selector, container$).val(this.subject);
		var selJobs = jQuery.grep(that.jobList, function(jr) {
			return (jr.subject === theSubject);
		});
		if (selJobs && selJobs.length > 0) {
			var c$ = jQuery(selWr$).closest('.roiAssocGroup');
			if (typeof (this.vd) !== 'undefined') {
				var theVD = this.vd;
				var visitJobs = jQuery.grep(selJobs[0].jobs, function(job) {
					return job.vd === theVD;
				});
				for (i = 0; i < visitJobs.length; i++) {
					var rac$ = that.addJobAssocComp(jQuery('div.sjaPanel', c$),
							theSubject, selJobs[0]);
					vj = visitJobs[i];
					var key = vj.jid + ':' + vj.vid;
					jQuery('select[name^="jobSelector"]', rac$).val(key)
							.trigger('change');
				}
			} else {
				var rac$ = that.addJobAssocComp(jQuery('div.sjaPanel', c$),
						theSubject, selJobs[0]);
			}
		}
	});
}

clinical.RoiAssocComp.prototype.addJobAssocComp = function(container$,
		subjectId, theJR) {
	var i, len = this.jobList.length, that = this;
	if (typeof (theJR) === 'undefined') {
		for (i = 0; i < len; i++) {
			if (this.jobList[i].subject === subjectId) {
				theJR = this.jobList[i];
				break;
			}
		}
	}
	if (!theJR) {
		return;
	}
	var rac$ = jQuery('<div></div>').addClass('racItem').appendTo(container$);
	jQuery(rac$).data('suffix2', "." + this.assocCount++);
	jQuery('div.template.jobSelection').children().clone().appendTo(rac$);
	var jsComp$ =  jQuery('select[name^="jobSelector"]', rac$);
	jQuery.populateSelect(jsComp$.get(0), theJR.jobs, function(o) {
				var name = o.jid + ' ' + o.vd + '(' + o.vid + ') '
						+ ((o.label) ? '[' + o.label + ']' : '');
				var value = o.jid + ':' + o.vid;
				var ro = {
					name : name,
					value : value
				};
				if (o.desc) {
					ro.data = o.desc;
				}
				return ro;
			});
	jQuery(rac$).children().trigger('suffixName');
	jQuery(jsComp$).bind(
			'change',
			that,
			function(event) {
				var c$ = jQuery(this).closest('.racItem');
				var selOpt = jQuery(':selected', this);
				var desc = selOpt.data('ctx');
				if (!desc) {
					return;
				}
				var dc$ = jQuery('.racItemDesc', c$);
				if (dc$.length == 0) {
					dc$ = jQuery('<div></div>').addClass('racItemDesc').appendTo(c$);
               jQuery(c$).addClass('racBorderedItem');
				}
				jQuery(dc$).html(
						'<span class="label">Description:</span> <span>' + 
						  desc	+ '</span>');
			}).trigger('change');
	return rac$;
}

clinical.RoiAssocComp.prototype.collectAssociations = function() {
	var results = [], that = this, container$ = this.rootEl$;

	jQuery.each(this.roiList, function(idx) {
		var selector = 'select[name="subjectSelector.' + idx + '"]';
		var selWr$ = jQuery(selector, container$), i, j, assocRec, job, jobKey;
		var selSubject = jQuery(selWr$).val();
		var selJobs = jQuery.grep(that.jobList, function(jr) {
			return jr.subject === selSubject;
		});
		if (selJobs && selJobs.length > 0) {
			assocRec = {
				roi : this,
				jobs : [],
				subject : selSubject,
				expName : ""
			};
			results.push(assocRec);
			var c$ = jQuery(selWr$).closest('.roiAssocGroup');
			var keys = [];
			jQuery('select[name^="jobSelector"]', jQuery('div.sjaPanel', c$))
					.each(function() {
						var key = jQuery(':selected', this).val();
						keys.push(key);
					});
			// alert('keys:' + keys);
			var jobs = selJobs[0].jobs;
			assocRec.expName = selJobs[0].expName;
			for (i = 0; i < keys.length; i++) {
				for (j = 0; j < jobs.length; j++) {
					var job = jobs[j];
					var jobKey = job.jid + ':' + job.vid;
					if (jobKey === keys[i]) {
						assocRec.jobs.push(job);
					}
				}
			}
		}
	});
	var resultsObj = {
		results : results
	};
	return JSON.stringify(resultsObj);
}
