var clinical = clinical || {};

clinical.SynAdmin = function(asList, svURL, asExpURL, addSynUrl, listSynUrl, delSynUrl) {
   this.asList = asList;
   this.svURL = svURL;
   this.asExpURL = asExpURL;
   this.addSynUrl = addSynUrl;
   this.listSynUrl = listSynUrl;
   this.delSynUrl = delSynUrl;
   var asSelector$ = jQuery('.asChooser');
   jQuery.populateSelect(asSelector$[0], this.asList, function(o) {
       return { name: o.name, value: o.asId};
   });

   var prepAsExperiments = function(asId) {
       jQuery.ajax({url:asExpURL,
         data:{asID:asId}
       }).done(function(data) {
           console.log(data);
           var aeSel$ = jQuery('#expFilter');
           jQuery.populateSelect(aeSel$[0], data.expList, function(o) {
                return {name:o.name, value:o.id};
           });
       });
   };

   jQuery(asSelector$).live('change', this, function(event) {
     var asId = jQuery(':selected', this).val();
     // prepAsExperiments(asId);
     var asRec = jQuery.grep(event.data.asList, function(o) {
         return o.asId == asId; })[0];
     var strScores = jQuery.grep(asRec.scores, function(score) {
         return score.type === 'varchar'; });
     var scoreSel$ = jQuery('.scoreChooser');
     jQuery.populateSelect(scoreSel$[0], strScores, function(o) {
        return { name:o.name, value:o.name };
     });
     scoreSel$.trigger('change');
   }).trigger('change');

   jQuery('.scoreChooser').live('change', this, function(event) {
      var asId = jQuery(':selected', '.asChooser').val();
      var selScore = jQuery(':selected', this).val();
      // prep synonym entry panel
      jQuery.ajax({
        url:svURL,
        data:{asID:asId, scoreName: selScore}}).done(function(data) {
           // console.log(data);  
           var svSel$ = jQuery('#svFilter');
           jQuery.populateSelect(svSel$[0], data.posVals, function(o) {
              return {name:o, value:o};
           });
        });
   });

   var populateSynonymList = function() {
      jQuery.ajax({
          url:listSynUrl,
      }).done(function(data) {
        // console.log(data);
        if (data) {
           var tb$ = jQuery('tbody',jQuery('#ssListTable'));
           tb$.children().remove();
           for(var i = 0; i < data.length; ++i) {
               var rd = data[i];
               var tr$ = jQuery('<tr></tr>').addClass('trsl').appendTo(tb$);
               jQuery('<td>'+ rd.scoreName + '</td>').appendTo(tr$);
               jQuery('<td>'+ rd.assessmentName + '</td>').appendTo(tr$);
               jQuery('<td>' + rd.synonyms + '</td>').appendTo(tr$);
               jQuery('<td>' + rd.canonicalValue + '</td>').appendTo(tr$);
               var td$ = jQuery('<td></td>');
               td$.appendTo(tr$);
               jQuery('<button></button>').addClass('synonymRemover')
                   .attr('title','Remove Synonym').data('ssid',rd.id).appendTo(td$);
           }
        }
      });
   };

   jQuery('.synonymRemover').live('click', function(event) {
       var ssid = jQuery(this).data('ssid');
       //console.log('ssid='+ssid);
       jQuery.ajax({
          url: delSynUrl,
          data:{ssid:ssid}
       }).done(function(data) {
          populateSynonymList();
       });
   });


   jQuery('#addSynonym').click(function(event) {
       var cv = jQuery.trim(jQuery('#canonicalValue').val()),
           asID = jQuery('#asFilter option:selected').val(),
           scoreValues = [], selExpIds = [],
           scoreName = jQuery('#scoreFilter option:selected').val();
       jQuery('#svFilter option:selected').each( function() { scoreValues.push( jQuery(this).val() ); });
       jQuery('#expFilter option:selected').each( function() { selExpIds.push( jQuery(this).val() ); });
       jQuery.ajax({
          url: addSynUrl,
          data: {asID: asID, scoreName: scoreName, svFilter:scoreValues, expFilter: selExpIds,
                 canonicalValue:cv}
       }).done(function(data) {
             //console.log(data);
             populateSynonymList();
       }).fail(function(req,status,error) {
           alert(error);
       });
   });
   populateSynonymList();


}
