/*
 * Utility functions
 *
 */

// namespace
var utils = new Object();

utils.trim = function(val) { // bl_trim
	if (val.length == 0) {
		return val;
	}
	var leftIdx = 0, i, rightIdx, c;
	for (i = 0; i < val.length; i++) {
		c = val.charAt(i);
		if (c !== ' ') {
			break;
		} else {
			leftIdx++;
		}
	}
	rightIdx = val.length;
	for (i = val.length - 1; i >= leftIdx; i--) {
		if (val.charAt(i) !== ' ') {
			break;
		} else {
			rightIdx--;
		}
	}
	return val.substring(leftIdx, rightIdx);
}

/* Hash table class */

utils.Hash = function() {
	this.length = 0;
	this.items = [];
	for ( var i = 0; i < arguments.length; i += 2) {
		if (typeof (arguments[i + 1]) !== 'undefined') {
			this.items[arguments[i]] = arguments[i + 1];
			this.length++;
		}
	}

	this.removeItem = function(in_key) {
		var tmp_value;
		if (typeof (this.items[in_key]) !== 'undefined') {
			this.length--;
			var tmp_value = this.items[in_key];
			delete this.items[in_key];
		}
		return tmp_value;
	}

	this.getItem = function(in_key) {
		return this.items[in_key];
	}

	this.setItem = function(in_key, in_value) {
		if (typeof (in_value) !== 'undefined') {
			if (typeof (this.items[in_key]) === 'undefined') {
				this.length++;
			}
			this.items[in_key] = in_value;
		}
		return in_value;
	}

	this.hasItem = function(in_key) {
		return typeof (this.items[in_key]) !== 'undefined';
	}
}

/* functions adapted from x library 

// x_core.js, part of X, a Cross-Browser.com Javascript Library
// Copyright (C) 2001,2002,2003,2004,2005 Michael Foster - Distributed under the terms of the GNU LGPL - OSI Certified
// File Rev: 5

*/

utils.xGetElementById = function(e) {
	if (typeof (e) === 'string') {
		if (document.getElementById)
			e = document.getElementById(e);
		else if (document.all)
			e = document.all[e];
		else
			e = null;
	}
	return e;
}

utils.xHasClass = function(e, c) {
	e = utils.xGetElementById(e);
	if (!e || e.className === '')
		return false;
	var re = new RegExp("(^|\\s)" + c + "(\\s|$)");
	return re.test(e.className);
}

utils.xGetElementsByTagName = function(tagName, parentEle)
{
  var list = null;
  tagName = tagName || '*';
  parentEle = parentEle || document;
  if (parentEle.all) {
    if (tagName == '*') list = parentEle.all;
    else list = parentEle.all.tags(tagName);
  }
  else if (parentEle.getElementsByTagName) list = parentEle.getElementsByTagName(tagName);
  return list || new Array();
}

utils.xAddClass = function(e, c) {
	if ((e = utils.xGetElementById(e)) != null) {
		var s = '';
		if (e.className.length
				&& e.className.charAt(e.className.length - 1) !== ' ') {
			s = ' ';
		}
		if (!utils.xHasClass(e, c)) {
			e.className += s + c;
			return true;
		}
	}
	return false;
}

utils.xWidth = function(e,uW) {
  if(!(e=utils.xGetElementById(e))) return 0;
  if (utils.xNum(uW)) {
    if (uW<0) uW = 0;
    else uW=Math.round(uW);
  }
  else uW=-1;
  var css=utils.xDef(e.style);
  if(css && utils.xDef(e.offsetWidth) && utils.xStr(e.style.width)) {
    if(uW>=0) xSetCW(e, uW);
    uW=e.offsetWidth;
  }
  else if(css && utils.xDef(e.style.pixelWidth)) {
    if(uW>=0) e.style.pixelWidth=uW;
    uW=e.style.pixelWidth;
  }
  return uW;
}

utils.xGetCS = function(ele,sP){
  return parseInt(document.defaultView.getComputedStyle(ele,'').getPropertyValue(sP));}

utils.xSetCW = function(ele,uW){
  var pl=0,pr=0,bl=0,br=0;
  if(utils.xDef(document.defaultView) && utils.xDef(document.defaultView.getComputedStyle)){
    pl=utils.xGetCS(ele,'padding-left');
    pr=utils.xGetCS(ele,'padding-right');
    bl=utils.xGetCS(ele,'border-left-width');
    br=utils.xGetCS(ele,'border-right-width');
  }
  else if(utils.xDef(ele.currentStyle,document.compatMode)){
    if(document.compatMode=='CSS1Compat'){
      pl=parseInt(ele.currentStyle.paddingLeft);
      pr=parseInt(ele.currentStyle.paddingRight);
      bl=parseInt(ele.currentStyle.borderLeftWidth);
      br=parseInt(ele.currentStyle.borderRightWidth);
    }
  }
  else if(utils.xDef(ele.offsetWidth,ele.style.width)){ // ?
    ele.style.width=uW+'px';
    pl=ele.offsetWidth-uW;
  }
  if(isNaN(pl)) pl=0; if(isNaN(pr)) pr=0; if(isNaN(bl)) bl=0; if(isNaN(br)) br=0;
  var cssW=uW-(pl+pr+bl+br);
  if(isNaN(cssW)||cssW<0) return;
  else ele.style.width=cssW+'px';
}


utils.xDef = function() {
 for(var i=0; i<arguments.length; ++i){
     if(typeof(arguments[i])=='undefined') return false;}
  return true;
}

utils.xStr = function() {
  for(var i=0; i<arguments.length; ++i){if(typeof(arguments[i])!='string') return false;}
  return true;
}

utils.xNum = function() {
  for(var i=0; i<arguments.length; ++i){if(typeof(arguments[i])!='number') return false;}
  return true;
}


utils.xMoveTo = function(e,iX,iY) {
  utils.xLeft(e,iX);
  utils.xTop(e,iY);
}

utils.xLeft = function(e,iX) {
  if(!(e=utils.xGetElementById(e))) return 0;
  var css=utils.xDef(e.style);
  if (css && utils.xStr(e.style.left)) {
    if(utils.xNum(iX)) e.style.left=iX+'px';
    else {
      iX=parseInt(e.style.left);
      if(isNaN(iX)) iX=0;
    }
  }
  else if(css && utils.xDef(e.style.pixelLeft)) {
    if(utils.xNum(iX)) e.style.pixelLeft=iX;
    else iX=e.style.pixelLeft;
  }
  return iX;
}

utils.xTop = function(e,iY) {
  if(!(e=utils.xGetElementById(e))) return 0;
  var css=utils.xDef(e.style);
  if(css && utils.xStr(e.style.top)) {
    if(utils.xNum(iY)) e.style.top=iY+'px';
    else {
      iY=parseInt(e.style.top);
      if(isNaN(iY)) iY=0;
    }
  }
  else if(css && utils.xDef(e.style.pixelTop)) {
    if(utils.xNum(iY)) e.style.pixelTop=iY;
    else iY=e.style.pixelTop;
  }
  return iY;
}


/*-- end of functions adapted from x library --*/

utils.dumpProperties = function(anObj, bShow) {
	if (!anObj) {
		return null;
	}
	var descr = "", i, prop;
	for (i in anObj) {
		prop = anObj[i];
		descr += i + "=" + prop + "\n";
	}
	if (bShow)
		alert(descr);
	return descr;
}

utils.strEndsWith = function(src, suffix) {
	var d = src.length - suffix.length;
	return d >= 0 && src.indexOf(suffix) === d;
}

// for expand/collapse table rows

utils.collapseExpand = function(parentElem, asIdx) {
	var elemId = "as_" + asIdx + "_t0";
	var elem = $(elemId), children, imgElem, id, msElem;
	if (elem) {
		children = parentElem.descendants();
		if (children && children.length > 0) {
			imgElem = children[0];
			if (utils.strEndsWith(imgElem.src, "images/collapse.gif")) {
				imgElem.src = "images/expand.gif";
			} else {
				imgElem.src = "images/collapse.gif";
			}
		}
		elem.toggle();
		utils.toggleAll("as_" + asIdx + "_t", 1);
		utils.toggleAll("as_" + asIdx + "_v", 0);
		id = 'as_ms' + asIdx + "_1";
		msElem = $(id);
		if (msElem) {
			msElem.toggle();
			msElem = $('as_ms' + asIdx + "_2");
			if (msElem) {
				msElem.toggle();
			}
		}
	}
	return false;
}

utils.toggleAll = function(prefix, startIdx) {
	var elemId = prefix + startIdx;
	var elem = null;
	var count = 0;
	while ((elem = $(elemId))) {
		elem.toggle();
		startIdx++;
		elemId = prefix + startIdx;
		++count;
		if (count > 1000)
			break;
	}
}

/*
 * formats file size in bytes in human readable shorthand format
 */
utils.formatFileSize = function(fileSize) {
	var s = '';
	if (fileSize < 1024) {
		s = fileSize + 'B';
	} else if (fileSize >= 1024 && fileSize < 1048576) {
		s = Math.round(fileSize / 1024.0) + 'Kb';
	} else if (fileSize >= 1048576 && fileSize < 1073741824) {
		s = Math.round(fileSize / 1048576.0) + 'Mb';
	} else if (fileSize >= 1073741824) {
		var value = fileSize / 1073741824.0;
		s = Math.round(value * 100) / 100 + 'Gb';
	}
	return s;
}

// DOM creation utilities

utils.createSelect = function(id, opts) {
	var nd = document.createElement('select');
	if (id) {
		nd.setAttribute("id", id);
	}
	if (opts) {
		var i, option;
		for (i = 0; i < opts.length; i++) {
			option = new Option(opts[i].label, opts[i].value);
			try {
				nd.add(option, null);
			} catch (e) {
				nd.add(option, -1);
			}
		}
	}
	return nd;
}

utils.styledText = function(text, style) {
	var nd = document.createElement('span');
	var txtNode = document.createTextNode(text);
	nd.appendChild(txtNode);
	nd = $(nd);
	if (style) {
		nd.setStyle(style);
	}
	return nd;
}

utils.newDomNode = function(tag, id, content) {
	var nd = document.createElement(tag), 
	   txtNode;
	if (id) {
		nd.setAttribute("id", id);
	}
	if (content) {
		txtNode = document.createTextNode(content);
		nd.appendChild(txtNode);
	}
	return $(nd);
}

utils.newRadioBut = function(id, name, label, value, checked) {
	return utils.newCheckable('radio', id, name, label, value, checked);
}

utils.newCheckBox = function(id, name, label, value, checked) {
	return utils.newCheckable('checkbox', id, name, label, value, checked);
}

utils.newCheckable = function(type, id, name, label, value, checked) {
	var nd = document.createElement('input'), txtNd, labelEl;
	nd.setAttribute('type', type);
	if (id)
		nd.setAttribute('id', id);
	if (name)
		nd.setAttribute('name', name);
	if (value)
		nd.setAttribute('value', value);
	if (checked)
		nd.checked = true;
	labelEl = document.createElement("label");
	labelEl.appendChild(nd);
	txtNd = document.createTextNode(label ? label : value);
	labelEl.appendChild(txtNd);
	return $(labelEl);
}

utils.createHiddenField = function(name, value) {
	var he = document.createElement('input');
	he.type = 'hidden';
	he.name = name;
	he.value = value;
	return he;
}

utils.openRemote = function(aURL, aName, aHeight, aWidth, features, orgName) {
	var newFeatures, newWin, ah,aw, xc, yc;
	if (aHeight) {
		aHeight = screen.availHeight - 80;
	}
	if (aWidth) {
		aWidth = screen.availWidth - 30;
	}
	newFeatures = "height=" + aHeight + ",innerHeight=" + aHeight;
	newFeatures += ",width=" + aWidth + ",innerWidth=" + aWidth;
	if (window.screen) {
		ah = screen.availHeight - 30;
		aw = screen.availWidth - 10;
		xc = (aw - aWidth) / 2;
		yc = (ah - aHeight) / 2;
		newFeatures += ",left=" + xc + ",screenX=" + xc;
		newFeatures += ",top=" + yc + ",screenY=" + yc;
		newFeatures += "," + features;
	}
	newWin = openWindow(aURL, aName, newFeatures, orgName);
	newWin.focus();
	return newWin;
}

utils.openWindow = function(aURL, aName, features, orgName) {
	var aWin = open(aURL, aName, features);
	if (aWin.opener === null) {
		aWin.opener = window;
	}
	aWin.opener.name = orgName;
	return aWin;
}

/*
 * given a form name and element name returns the corresponding element from the
 * form or null if there is no such element.
 */
utils.findElement = function(form, elemName) {
	var i;
	for (i = 0; i < form.elements.length; ++i) {
		if (form.elements[i].name == elemName)
			return form.elements[i];
	}
	return null;
}

utils.scrollX = function() {
	var de = document.documentElement;
	return self.pageXOffset || (de & de.scrollLeft) || document.body.scrollLeft;
}

utils.scrollY = function() {
	var de = document.documentElement;
	return self.pageYOffset || (de && de.scrollTop) || document.body.scrollTop;
}

utils.windowHeight = function() {
	var de = document.documentElement;
	return self.innerHeight || (de && de.clientHeight)
			|| document.body.clientHeight;
}

utils.windowWidth = function() {
	var de = document.documentElement;
	return self.innerWidth || (de && de.clientWidth)
			|| document.body.clientWidth;
}

utils.getStyle = function(elem, name) {
	if (elem.style[name]) {
		return elem.style[name];
	} else if (elem.currentStyle) {
		return elem.currentStyle[name];
	} else if (document.defaultView && document.defaultView.getComputedStyle) {
		name = name.replace(/([A-Z])/g, "-$1");
		name = name.toLowerCase();
		var s = document.defaultView.getComputedStyle(elem, "");
		return s && s.getPropertyValue(name);
	}
	return null;
}

utils.hide = function(elem) {
	var curStyle = utils.getStyle(elem, 'display');
	if (curStyle != 'none')
		elem.$oldDisplay = curStyle;
	elem.style.display = 'none';
	elem.style.visibility = 'hidden';
}

utils.show = function(elem) {
	elem.style.display = elem.$oldDisplay || '';
	elem.style.visibility = 'visible';
}
