var clinical = clinical || {};

clinical.validateBirnID = function(elem) {
    var str = (typeof elem === "string") ? elem : elem.value,
        reg = /^([A-Z]+|\d\d\d\d)\d\d\d\d\d\d\d\d$/;
    return reg.test(str);
};

clinical.validateTime = function(str) {
    var reg = /^[0-2]?[0-9]:[0-5][0-9]$/,
        tokens;
    if (reg.test(str) ) {
      tokens = str.split(":");
      if (tokens[0] <= 23 && tokens[1] <= 59)
        return true;
    }
    return false;
};

 // mm/dd/yyyy format
clinical.validateDate = function(str) {
   var daysOfMonths = [31,28,31,30,31,30,31,31,30,31,30,31],
       reg = /^[0-1]?[0-9]\/[0-3]?[0-9]\/[0-9][0-9][0-9][0-9]$/,
       tokens, month, day, year;
   if ( reg.test(str) ) {
     tokens = str.split("/");
     month = tokens[0];
     day = tokens[1];
     year = tokens[2];
     if (month > 12 || day > 31) {
        return false;
     }
     if ( month === "2") {
       if ( isLeapYear(year) ) {
         return day <= 29;
       } else {
         return day <= 28;
       }
     } else {
        return day <= daysOfMonths[ month - 1 ];
     }
   }
   return false;
};

clinical.isLeapYear = function(year) {
    if ((year % 4) !== 0) {
      return false;
    }
    if ( (year % 400) === 0) {
 	   return true;
    }
    if ( (year % 100) === 0) {
       return false;
    }
    return true;
};


clinical.validateFields  = function(form, fieldNames, validations, errMsgs) {
  var fieldNameMap = [], nameValidationMap = [], 
      i, valMsg, foundErrors, ok, validationType;
  for(i=0; i < fieldNames.length; ++i) {
     fieldNameMap[ fieldNames[i] ] = errMsgs[i];
     nameValidationMap[ fieldNames[i] ] = validations[i];
  }
  valMsg = "Please correct the following validation error(s):\n\n";
  foundErrors = false;
  for(i=0; i < form.elements.length; ++i) {
     if (  fieldNameMap[ form.elements[i].name ] !== null) {
         // alert(">> " + form.elements[i].name);
         validationType = nameValidationMap[ form.elements[i].name ];
         ok = false;
         if ( validationType === "date") {
            alert("validating date "+ form.elements[i].value);
            ok = validateDate( form.elements[i].value );
         } else if ( validationType === "time") {
            ok = validateTime( form.elements[i].value );
         }
         if (!ok) {
            foundErrors = true;
            valMsg += fieldNameMap[form.elements[i].name ] + "\n";
         }
     }
  }
  if (foundErrors ) {
     alert(valMsg);
     return false;
  }
  return true;
};

clinical.convertToElementMap = function(form) {
    var nameElemMap = [], i;
    for(i=0; i < form.elements.length; ++i) {
      nameElemMap[ form.elements[i].name ] = form.elements[i];
    }
    return nameElemMap;
};

clinical.isNumber = function(n) {
   return !isNaN(parseFloat(n)) && isFinite(n);
};

