--return equipment_id if exists or -1 otherwise
create or replace FUNCTION get_equipment_id(
   maker_in varchar2,  model_in varchar2
) return number
IS
v_uid NUMBER;
BEGIN
  select max(UNIQUEID) into v_uid from nc_collectionequipment
  where lower(MAKE) = lower(maker_in) and lower(MODEL) = lower(model_in);
  if v_uid is null then
     v_uid := -1;
  end if;
  return v_uid;
EXCEPTION
  when others then
    return -1;
END; 
/


create or replace procedure add_collectionequipment(
       maker_in varchar2,  
       model_in varchar2,
       owner_id_in number,
       mod_user_id_in number) 
is
begin
   if get_equipment_id(maker_in, model_in) = -1 then
      insert into nc_collectionequipment ( UNIQUEID, TABLEID, OWNER, MODTIME, MODUSER,
	        make, model)
      values( uid_seq.nextval, get_table_id('nc_collectionequipment'), owner_id_in, 
     		SYSDATE, mod_user_id_in, maker_in, model_in);
   end if; 
end;
/

create or replace PROCEDURE add_raw_data(owner_id_in number, 
    mod_user_id_in number,
    SEGMENTID_in number,
    COMPONENTID_in number,
    EXPERIMENTID_in number,
    SUBJECTID_in varchar2, 
    DATAURI_in varchar2,
    PROTOCOLVERSION_in number, 
    PROTOCOLID_in varchar2, 
    EQUIPMENTID_in varchar2, 
    ONTOLOGYSOURCE_in varchar2,
    CONCEPTID_in number,
    ISBAD_in number := 0)
IS
  
BEGIN
      insert into nc_rawdata(UNIQUEID, TABLEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, SEGMENTID, 
	COMPONENTID, NC_EXPERIMENT_UNIQUEID, SUBJECTID, DATAURI, ISRAW, PROTOCOLVERSION, PROTOCOLID,
	NC_COLEQUIPMENT_UNIQUEID, ONTOLOGYSOURCE, CONCEPTID, ISBAD)
      values(uid_seq.nextval, get_table_id('nc_rawdata'), owner_id_in, SYSDATE, mod_user_id_in,
	'nc_rawdata', SEGMENTID_in, COMPONENTID_in, EXPERIMENTID_in, SUBJECTID_in, DATAURI_in, 1,
        PROTOCOLVERSION_in, PROTOCOLID_in, EQUIPMENTID_in, ONTOLOGYSOURCE_in, CONCEPTID_in, ISBAD_in);
END;
/ 


