--DYW, 2005-04-21

-- returns id or -1 if not exists
create or replace FUNCTION get_database_user_id(uname_in VARCHAR2) RETURN NUMBER
IS
v_id NUMBER;
v_return NUMBER;
CURSOR user_cur IS SELECT min(UNIQUEID) FROM  nc_databaseUser 
    WHERE NAME = uname_in; 
BEGIN
  OPEN user_cur;
  FETCH user_cur INTO v_id;
  IF user_cur%NOTFOUND THEN
     v_return := -1;
  ELSE
     v_return := v_id;
  END IF;
  close user_cur;
  return v_return;
END;
/

-- returns id or -1 if not exists
create or replace FUNCTION get_table_id(uname_in VARCHAR2) RETURN NUMBER
IS
v_id NUMBER;
v_return NUMBER;
CURSOR user_cur IS SELECT tableID FROM  nc_tableID 
    WHERE tableNAME = UPPER(uname_in); 
BEGIN
  OPEN user_cur;
  FETCH user_cur INTO v_id;
  IF user_cur%NOTFOUND THEN
     v_return := -1;
  ELSE
     v_return := v_id;
  END IF;
  close user_cur;
  return v_return;
END;
/

-- returns id or -1 if not exists
create or replace FUNCTION get_person_id(
  first_name_in VARCHAR2, 
  last_name_in VARCHAR2, 
  email_in VARCHAR2
) RETURN NUMBER
IS
v_id NUMBER;
v_return NUMBER;
CURSOR user_cur IS SELECT UNIQUEID FROM  nc_person 
    WHERE upper(first_name) = UPPER( first_name_in )
    and upper(last_name) = upper(last_name_in )
    and upper(email) = upper(email_in); 
BEGIN
  OPEN user_cur;
  FETCH user_cur INTO v_id;
  IF user_cur%NOTFOUND THEN
     v_return := -1;
  ELSE
     v_return := v_id;
  END IF;
  close user_cur;
  return v_return;
END;
/

-- returns id or -1 if not exists
create or replace FUNCTION get_userClass_id(
  uclass_in VARCHAR2
) RETURN NUMBER
IS
v_id NUMBER;
v_return NUMBER;
CURSOR user_cur IS SELECT max(UNIQUEID) FROM  nc_userClass
    WHERE upper(USERCLASS) = UPPER( uclass_in );
BEGIN
  OPEN user_cur;
  FETCH user_cur INTO v_id;
  IF user_cur%NOTFOUND THEN
     v_return := -1;
  ELSE
     v_return := v_id;
  END IF;
  close user_cur;
  return v_return;
END;
/

-- returns id or -1 if not exists
create or replace FUNCTION get_userStatus_id(
  userStatus_in VARCHAR2
) RETURN NUMBER
IS
v_id NUMBER;
v_return NUMBER;
CURSOR user_cur IS SELECT max(UNIQUEID) FROM  nc_userStatus 
    WHERE upper(userStatus) = UPPER( userStatus_in );
BEGIN
  OPEN user_cur;
  FETCH user_cur INTO v_id;
  IF user_cur%NOTFOUND THEN
     v_return := -1;
  ELSE
     v_return := v_id;
  END IF;
  close user_cur;
  return v_return;
END;
/
-- return id or -1 when failed
-- add the user without validating owner_name_in when owner_name_in = db_user_name_in
create or replace function create_birn_user(owner_name_in VARCHAR2,
  mod_user_in VARCHAR2,
  first_name_in VARCHAR2,
  last_name_in VARCHAR2,
  email_in VARCHAR2,
  db_user_name_in VARCHAR2,
  user_class_in VARCHAR2,
  group_id_in NUMBER := -1 
) return number
IS
 owner_id NUMBER;
 mod_user_id NUMBER;
 person_id NUMBER; 
 db_user_id NUMBER;
 group_id NUMBER;
 v_table_id number;
BEGIN
   SELECT uid_seq.nextval INTO db_user_id FROM dual;
   if owner_name_in != db_user_name_in then
      owner_id := get_database_user_id(owner_name_in);
      mod_user_id :=  get_database_user_id(mod_user_in);
      IF owner_id < 0 OR mod_user_id < 0 THEN
         RETURN -1;
      END IF;
   else
      owner_id := db_user_id;
      mod_user_id := db_user_id;
   end if;

   person_id := get_person_id(first_name_in, last_name_in, email_in) ;
   v_table_id := get_table_id('nc_person');
   if person_id < 0 then
     SELECT uid_seq.nextval INTO person_id FROM dual;
     insert into nc_person (UNIQUEID,TABLEID,OWNER,
        MODTIME,MODUSER,FIRST_NAME, LAST_NAME, EMAIL)
     values(person_id, v_table_id, owner_id, SYSDATE, mod_user_id, first_name_in,
        last_name_in, email_in);
   end if;
 
   IF group_id_in < 0 THEN
     -- create a new group with the db_user_name_in ,
     -- create the user and assign to the newly created group
     SELECT uid_seq.nextval INTO group_id FROM dual;
     insert into nc_databaseUser ( UNIQUEID,NAME,TABLEID,OWNER,MODTIME,MODUSER,USERCLASS,USERSTATUS,
            ISGROUP,PERSONID)
      values(group_id, lower(db_user_name_in), get_table_id('nc_databaseUser'), owner_id, SYSDATE, mod_user_id, get_userClass_id(user_class_in),get_userStatus_id('active'), 1, person_id); 
   else
     group_id := group_id_in ;
   end if;      
   
insert into nc_databaseUser ( UNIQUEID,NAME,TABLEID,OWNER,MODTIME,MODUSER,USERCLASS,USERSTATUS,
            ISGROUP,PERSONID)
   values(db_user_id, UPPER(db_user_name_in), get_table_id('nc_databaseUser'), owner_id, SYSDATE, mod_user_id, get_userClass_id(user_class_in),get_userStatus_id('active'), 0, person_id);   
       
   INSERT INTO nc_userGroup (USERID,GROUPID,UNIQUEID,TABLEID,OWNER,MODTIME,MODUSER)
   VALUES(db_user_id, group_id, uid_seq.nextval, get_table_id('nc_userGroup'), owner_id, SYSDATE, mod_user_id); 

   return db_user_id;
END;
/
