DROP TABLE bk_tupleAccess CASCADE CONSTRAINTS
;
-- 
-- TABLE: bk_tupleAccess 
--

CREATE TABLE bk_tupleAccess(
    tupleID       NUMBER(38, 0)    NOT NULL,
    tableID       NUMBER(38, 0)    NOT NULL,
    grantee       NUMBER(38, 0)    NOT NULL,
    grantor       NUMBER(38, 0)    NOT NULL,
    modTime       DATE             NOT NULL,
    owner         NUMBER(38, 0)    NOT NULL,
    modUser       NUMBER(38, 0)    NOT NULL,
    can_read      NUMBER(1, 0)     NOT NULL,
    can_write     NUMBER(1, 0)     NOT NULL,
    can_delete    NUMBER(1, 0)     NOT NULL,
    can_admin     NUMBER(1, 0)     NOT NULL,
    CONSTRAINT bk_tupleAccess_pk PRIMARY KEY (tupleID, tableID, grantee, grantor, modTime)
 		USING INDEX
 		(CREATE INDEX bk_tupleAccess_pidx on bk_tupleAccess(tupleID, tableID, grantee, grantor, modTime)
		TABLESPACE &&tablespace_index),
    CONSTRAINT bk_tupleAccess_sk  UNIQUE (tupleID, tableID)
 		USING INDEX
 		(CREATE INDEX bk_tupleAccess_sidx on bk_tupleAccess(tupleID, tableID)
		TABLESPACE &&tablespace_index)
)
TABLESPACE &&tablespace_data
;



COMMENT ON TABLE bk_tupleAccess IS 'The bk_tupleAccess table stores all modified and/or deleted permissions from the nc_tupleAccess table.  This allows for complete audit trail of permissions changes within the database.'
;
COMMENT ON COLUMN bk_tupleAccess.tupleID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN bk_tupleAccess.tableID IS 'The tableID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the uniqueID column these two columns specify a global unique object/tuple identifier within the database.   This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The tableID also servers as a supplementary identifier that allows each tuple''s containing table to be easily denoted.'
;
COMMENT ON COLUMN bk_tupleAccess.grantee IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN bk_tupleAccess.grantor IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN bk_tupleAccess.modTime IS 'The modification time of the current entry (YEAR to FRACTION(5)).'
;
COMMENT ON COLUMN bk_tupleAccess.owner IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN bk_tupleAccess.modUser IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN bk_tupleAccess.can_read IS 'The isTrue domain is used to store boolean (i.e yes/no, true/false, or 1/0) data.  The default representation of the domain is that if the value is 1, then the field is true.  The name of the field should be descriptive (e.g. is*Condition* true).'
;
COMMENT ON COLUMN bk_tupleAccess.can_write IS 'The isTrue domain is used to store boolean (i.e yes/no, true/false, or 1/0) data.  The default representation of the domain is that if the value is 1, then the field is true.  The name of the field should be descriptive (e.g. is*Condition* true).'
;
COMMENT ON COLUMN bk_tupleAccess.can_delete IS 'The isTrue domain is used to store boolean (i.e yes/no, true/false, or 1/0) data.  The default representation of the domain is that if the value is 1, then the field is true.  The name of the field should be descriptive (e.g. is*Condition* true).'
;
COMMENT ON COLUMN bk_tupleAccess.can_admin IS 'The isTrue domain is used to store boolean (i.e yes/no, true/false, or 1/0) data.  The default representation of the domain is that if the value is 1, then the field is true.  The name of the field should be descriptive (e.g. is*Condition* true).'
;
