DROP TABLE nc_assessmentVarchar CASCADE CONSTRAINTS
;
-- 
-- TABLE: nc_assessmentVarchar 
--

CREATE TABLE nc_assessmentVarchar(
    tableID                       NUMBER(38, 0)    NOT NULL,
    nc_assessmentData_uniqueID    NUMBER(38, 0)    NOT NULL,
    scoreOrder                    NUMBER(38, 0)    NOT NULL,
    owner                         NUMBER(38, 0)    NOT NULL,
    modTime                       DATE             NOT NULL,
    modUser                       NUMBER(38, 0)    NOT NULL,
    textValue                     VARCHAR2(255),
    textNormValue                 VARCHAR2(255),
    comments                      CLOB,
    dataValue                     VARCHAR2(255),
    dataNormValue                 VARCHAR2(255),
    storedAssessmentID            NUMBER(38, 0)    NOT NULL,
    assessmentID                  NUMBER(38, 0)    NOT NULL,
    scoreName                     VARCHAR2(128)    NOT NULL,
    scoreType                     VARCHAR2(64)     NOT NULL,
    isValidated                   NUMBER(1, 0)      DEFAULT 0 NOT NULL,
    isRanked                      NUMBER(1, 0)      DEFAULT 0 NOT NULL,
    subjectID                     VARCHAR2(64)     NOT NULL,
    entryID                       NUMBER(38, 0),
    keyerID                       NUMBER(38, 0),
    raterID                       NUMBER(38, 0),
    classification                NUMBER(38, 0),
    uniqueID                      NUMBER(38, 0),
    CONSTRAINT nc_assessmentVarchar_pk PRIMARY KEY (tableID, nc_assessmentData_uniqueID)
 		USING INDEX
 		(CREATE INDEX nc_assessmentVarchar_pidx on nc_assessmentVarchar(tableID, nc_assessmentData_uniqueID)
		TABLESPACE &&tablespace_index),
    CONSTRAINT nc_assessmentVarchar_sk  UNIQUE (nc_assessmentData_uniqueID, tableID)
 		USING INDEX
 		(CREATE INDEX nc_assessmentVarchar_sidx on nc_assessmentVarchar(nc_assessmentData_uniqueID, tableID)
		TABLESPACE &&tablespace_index)
)
TABLESPACE &&tablespace_data
;



COMMENT ON COLUMN nc_assessmentVarchar.tableID IS 'The tableID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the uniqueID column these two columns specify a global unique object/tuple identifier within the database.   This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The tableID also servers as a supplementary identifier that allows each tuple''s containing table to be easily denoted.'
;
COMMENT ON COLUMN nc_assessmentVarchar.nc_assessmentData_uniqueID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_assessmentVarchar.scoreOrder IS 'The sequenceStep domain is used to represent the stage (or step) in a sequence of events. For example an experimental condition (i.e. nc_expCondition) that starts on the second segment and finishes on the fourth would have a start value of 2 and an end value of 4.
'
;
COMMENT ON COLUMN nc_assessmentVarchar.owner IS 'The database user who who owns the selected tuple.  This could be the user who created the entry or the user who manages/oversees the user who entered the tuple.'
;
COMMENT ON COLUMN nc_assessmentVarchar.modTime IS 'The modification time of the current entry (YEAR to FRACTION(5)).'
;
COMMENT ON COLUMN nc_assessmentVarchar.modUser IS 'The user who modified the current tuple entry.  This can be different than the owner; if the user is entering data for the owner or if a user edited a tuple.'
;
COMMENT ON COLUMN nc_assessmentVarchar.textValue IS 'The textValue column is used to store the textual representations of data from all types.  This provides an easy way to return the results from queries selecting values of diffferent types without the need for conversion.'
;
COMMENT ON COLUMN nc_assessmentVarchar.textNormValue IS 'The textValue column is used to store the textual representations of data from all types.  This provides an easy way to return the results from queries selecting values of diffferent types without the need for conversion.'
;
COMMENT ON COLUMN nc_assessmentVarchar.comments IS 'The description column is an open field for any comments or descriptions for a specific entry (i.e. tuple) in the database.'
;
COMMENT ON COLUMN nc_assessmentVarchar.dataValue IS 'The varcharData domain is used to hold native character or string data.'
;
COMMENT ON COLUMN nc_assessmentVarchar.dataNormValue IS 'The varcharData domain is used to hold native character or string data.'
;
COMMENT ON COLUMN nc_assessmentVarchar.storedAssessmentID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_assessmentVarchar.assessmentID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_assessmentVarchar.scoreName IS 'The name column is used to store the name of the object being described by the tuple. '
;
COMMENT ON COLUMN nc_assessmentVarchar.scoreType IS 'The type column describes the data type of the object being described by the tuple.'
;
COMMENT ON COLUMN nc_assessmentVarchar.isValidated IS 'The isTrue domain is used to store boolean (i.e yes/no, true/false, or 1/0) data.  The default representation of the domain is that if the value is 1, then the field is true.  The name of the field should be descriptive (e.g. is*Condition* true).'
;
COMMENT ON COLUMN nc_assessmentVarchar.isRanked IS 'The isTrue domain is used to store boolean (i.e yes/no, true/false, or 1/0) data.  The default representation of the domain is that if the value is 1, then the field is true.  The name of the field should be descriptive (e.g. is*Condition* true).'
;
COMMENT ON COLUMN nc_assessmentVarchar.subjectID IS 'The investigator ID for the research subject.'
;
COMMENT ON COLUMN nc_assessmentVarchar.entryID IS 'The sequenceID domain is used to define an ordered sequence of entries or objects (e.g. visits by a subject).  The sequence begins with 1.'
;
COMMENT ON COLUMN nc_assessmentVarchar.keyerID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_assessmentVarchar.raterID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_assessmentVarchar.classification IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_assessmentVarchar.uniqueID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
