DROP TABLE nc_executedTransform CASCADE CONSTRAINTS
;
-- 
-- TABLE: nc_executedTransform 
--

CREATE TABLE nc_executedTransform(
    uniqueID                    NUMBER(38, 0)    NOT NULL,
    tableID                     NUMBER(38, 0)    NOT NULL,
    owner                       NUMBER(38, 0)    NOT NULL,
    modTime                     DATE             NOT NULL,
    modUser                     NUMBER(38, 0)    NOT NULL,
    logicalTransformID          NUMBER(38, 0)    NOT NULL,
    sequenceStep                NUMBER(38, 0)     DEFAULT 1 NOT NULL,
    nc_databaseUser_uniqueID    NUMBER(38, 0)    NOT NULL,
    machineID                   NUMBER(38, 0)    NOT NULL,
    time_stamp                  TIMESTAMP(6)     NOT NULL,
    compilerID                  NUMBER(38, 0),
    CONSTRAINT nc_executedTransform_pk PRIMARY KEY (uniqueID)
 		USING INDEX
 		(CREATE INDEX nc_executedTransform_pidx on nc_executedTransform(uniqueID)
		TABLESPACE &&tablespace_index),
    CONSTRAINT nc_executedTransform_sk  UNIQUE (uniqueID, tableID)
 		USING INDEX
 		(CREATE INDEX nc_executedTransform_sidx on nc_executedTransform(uniqueID, tableID)
		TABLESPACE &&tablespace_index)
)
TABLESPACE &&tablespace_data
;



COMMENT ON COLUMN nc_executedTransform.uniqueID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_executedTransform.tableID IS 'The table identifier for all data stored within this table.  In conjunction with a unique ID creates a unique reference to all tuples within the database for tuple level access control.'
;
COMMENT ON COLUMN nc_executedTransform.owner IS 'The database user who who owns the selected tuple.  This could be the user who created the entry or the user who manages/oversees the user who entered the tuple.'
;
COMMENT ON COLUMN nc_executedTransform.modTime IS 'The modification time of the current entry (YEAR to FRACTION(5)).'
;
COMMENT ON COLUMN nc_executedTransform.modUser IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_executedTransform.logicalTransformID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_executedTransform.sequenceStep IS 'The sequenceStep domain is used to represent the stage (or step) in a sequence of events. For example an experimental condition (i.e. nc_expCondition) that starts on the second segment and finishes on the fourth would have a start value of 2 and an end value of 4.
'
;
COMMENT ON COLUMN nc_executedTransform.nc_databaseUser_uniqueID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_executedTransform.machineID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_executedTransform.time_stamp IS 'The timestamp domain is used to notate the date and time of an occurence (e.g. a subject visit, nc_expComponent).  The timestamp refers to the beginning (start) time for the object.'
;
COMMENT ON COLUMN nc_executedTransform.compilerID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
