DROP TABLE nc_expStudy CASCADE CONSTRAINTS
;
-- 
-- TABLE: nc_expStudy 
--

CREATE TABLE nc_expStudy(
    studyID           NUMBER(38, 0)       NOT NULL,
    componentID       NUMBER(38, 0)       NOT NULL,
    experimentID      NUMBER(38, 0)       NOT NULL,
    subjectID         VARCHAR2(64)        NOT NULL,
    uniqueID          NUMBER(38, 0)       NOT NULL,
    tableID           NUMBER(38, 0)       NOT NULL,
    owner             NUMBER(38, 0)       NOT NULL,
    modTime           DATE                NOT NULL,
    modUser           NUMBER(38, 0)       NOT NULL,
    time_stamp        TIMESTAMP(6)        NOT NULL,
    description       CLOB,
    name              VARCHAR2(128),
    isTimeInterval    NUMBER(1, 0)         DEFAULT 0 NOT NULL,
    timeInterval      DOUBLE PRECISION,
    CONSTRAINT nc_expStudy_pk PRIMARY KEY (studyID, componentID, experimentID, subjectID)
 		USING INDEX
 		(CREATE INDEX nc_expStudy_pidx on nc_expStudy(studyID, componentID, experimentID, subjectID)
		TABLESPACE &&tablespace_index),
    CONSTRAINT nc_expStudy_sk  UNIQUE (uniqueID, tableID)
 		USING INDEX
 		(CREATE INDEX nc_expStudy_sidx on nc_expStudy(uniqueID, tableID)
		TABLESPACE &&tablespace_index)
)
TABLESPACE &&tablespace_data
;



COMMENT ON COLUMN nc_expStudy.studyID IS 'The sequential ID of the visit segment. For example during a scanning visit each scan would be sequentially numbered.'
;
COMMENT ON COLUMN nc_expStudy.componentID IS 'The sequential identifier for a subject clinical or scanner visit'
;
COMMENT ON COLUMN nc_expStudy.experimentID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_expStudy.subjectID IS 'The investigator ID for the research subject.'
;
COMMENT ON COLUMN nc_expStudy.uniqueID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_expStudy.tableID IS 'The tableID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the uniqueID column these two columns specify a global unique object/tuple identifier within the database.   This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The tableID also servers as a supplementary identifier that allows each tuple''s containing table to be easily denoted.'
;
COMMENT ON COLUMN nc_expStudy.owner IS 'The database user who who owns the selected tuple.  This could be the user who created the entry or the user who manages/oversees the user who entered the tuple.'
;
COMMENT ON COLUMN nc_expStudy.modTime IS 'The modification time of the current entry (YEAR to FRACTION(5)).'
;
COMMENT ON COLUMN nc_expStudy.modUser IS 'The user who modified the current tuple entry.  This can be different than the owner; if the user is entering data for the owner or if a user edited a tuple.'
;
COMMENT ON COLUMN nc_expStudy.time_stamp IS 'The timestamp domain is used to notate the date and time of an occurence (e.g. a subject visit, nc_expComponent).  The timestamp refers to the beginning (start) time for the object.'
;
COMMENT ON COLUMN nc_expStudy.description IS 'The description column is an open field for any comments or descriptions for a specific entry (i.e. tuple) in the database.'
;
COMMENT ON COLUMN nc_expStudy.name IS 'The name column is used to store the name of the object being described by the tuple. '
;
COMMENT ON COLUMN nc_expStudy.isTimeInterval IS 'The isTrue domain is used to store boolean (i.e yes/no, true/false, or 1/0) data.  The default representation of the domain is that if the value is 1, then the field is true.  The name of the field should be descriptive (e.g. is*Condition* true).'
;
